<?php

$blogPage = new HudsonEdgeAdminPage(
	"8",
	esc_html__( "Blog", 'hudson' ),
	"fa fa-files-o"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"blogPage",
	$blogPage
);

// Blog Post Lists - General

$panel1 = new HudsonEdgePanel(
	esc_html__( "Blog Lists", 'hudson' ),
	"post_lists_general_panel"
);
$blogPage->addChild(
	"panel1",
	$panel1
);

$blog_style = new HudsonEdgeField(
	"select",
	"blog_style",
	"1",
	esc_html__( "Archive and Category Layout", 'hudson' ),
	esc_html__( "Choose a default blog layout for archived Blog Post Lists and Category Blog Lists", 'hudson' ),
	array(
		"1" => esc_html__( "Blog: Standard", 'hudson' ),
		"3" => esc_html__( "Blog: Masonry", 'hudson' ),
		"4" => esc_html__( "Blog: Masonry Full Width", 'hudson' ),
		"9" => esc_html__( "Blog: Standard Whole Post", 'hudson' ),
		"14" => esc_html__( "Blog: Masonry Gallery", 'hudson' ),
		"15" => esc_html__( "Blog: Masonry Gallery Full Width", 'hudson' )
	)
);
$panel1->addChild(
	"blog_style",
	$blog_style
);

$category_blog_sidebar = new HudsonEdgeField(
	"select",
	"category_blog_sidebar",
	"default",
	esc_html__( "Archive and Category Sidebar", 'hudson' ),
	esc_html__( "Choose a sidebar layout for archived Blog Post Lists and Category Blog Lists", 'hudson' ),
	array(
		"default" => esc_html__( "No Sidebar", 'hudson' ),
		"1" => esc_html__( "Sidebar 1/3 right", 'hudson' ),
		"2" => esc_html__( "Sidebar 1/4 right", 'hudson' ),
		"3" => esc_html__( "Sidebar 1/3 left", 'hudson' ),
		"4" => esc_html__( "Sidebar 1/4 left", 'hudson' )
	)
);
$panel1->addChild(
	"category_blog_sidebar",
	$category_blog_sidebar
);

$pagination = new HudsonEdgeField(
	"yesno",
	"pagination",
	"yes",
	esc_html__( "Pagination", 'hudson' ),
	esc_html__( "Enabling this option will display pagination links on bottom of Blog Post List", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_hide_pagination_list_container"
	)
);
$panel1->addChild(
	"pagination",
	$pagination
);

$blog_hide_pagination_list_container = new HudsonEdgeContainer(
	"blog_hide_pagination_list_container",
	"pagination",
	""
);
$panel1->addChild(
	"blog_hide_pagination_list_container",
	$blog_hide_pagination_list_container
);

$blog_pagination_type = new HudsonEdgeField(
	"select",
	"blog_pagination_type",
	"standard",
	esc_html__( "Pagination type", 'hudson' ),
	esc_html__( "Choose type of pagination", 'hudson' ),
	array(
		"standard" => esc_html__( "Standard", 'hudson' ),
		"prev_and_next" => esc_html__( "Only Previous and Next", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"prev_and_next" => "#edgtf_blog_page_range_container",
			"standard"      => "#edgtf_blog_pagination_text_container"
		),
		"show"       => array(
			"standard"      => "#edgtf_blog_page_range_container",
			"prev_and_next" => "#edgtf_blog_pagination_text_container"
		)
	)
);
$blog_hide_pagination_list_container->addChild(
	"blog_pagination_type",
	$blog_pagination_type
);

$blog_page_range_container = new HudsonEdgeContainer(
	"blog_page_range_container",
	"blog_pagination_type",
	"prev_and_next"
);
$blog_hide_pagination_list_container->addChild(
	"blog_page_range_container",
	$blog_page_range_container
);

$blog_page_range = new HudsonEdgeField(
	"text",
	"blog_page_range",
	"",
	esc_html__( "Pagination Range limit", 'hudson' ),
	esc_html__( "Enter a number that will limit pagination to a certain range of links", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_page_range_container->addChild(
	"blog_page_range",
	$blog_page_range
);

$blog_pagination_text_container = new HudsonEdgeContainer(
	"blog_pagination_text_container",
	"blog_pagination_type",
	"standard"
);
$blog_hide_pagination_list_container->addChild(
	"blog_pagination_text_container",
	$blog_pagination_text_container
);

$group17 = new HudsonEdgeGroup(
	esc_html__( "Labels for Buttons", 'hudson' ),
	esc_html__( "Enter labels you want for Previous and Next buttons (Previous and Next are standard labels)", 'hudson' )
);
$blog_pagination_text_container->addChild(
	"group17",
	$group17
);

$row1 = new HudsonEdgeRow();
$group17->addChild(
	"row1",
	$row1
);

$blog_pagination_previous_label = new HudsonEdgeField(
	"textsimple",
	"blog_pagination_previous_label",
	"",
	esc_html__( "Previous Label", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_pagination_previous_label",
	$blog_pagination_previous_label
);

$blog_pagination_next_label = new HudsonEdgeField(
	"textsimple",
	"blog_pagination_next_label",
	"",
	esc_html__( "Next Label", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_pagination_next_label",
	$blog_pagination_next_label
);

$blog_pagination_border_above_yesno = new HudsonEdgeField(
	"yesno",
	"blog_pagination_border_above_yesno",
	"no",
	esc_html__( "Border Above Pagination", 'hudson' ),
	esc_html__( "Enabling this option will display border above pagination", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_show_on_yes" => "#edgtf_blog_pagination_border_container"
	)
);
$blog_page_range_container->addChild(
	"blog_pagination_border_above_yesno",
	$blog_pagination_border_above_yesno
);

$blog_pagination_border_container = new HudsonEdgeContainer(
	"blog_pagination_border_container",
	"blog_pagination_border_above_yesno",
	"no"
);
$blog_page_range_container->addChild(
	"blog_pagination_border_container",
	$blog_pagination_border_container
);

$group18 = new HudsonEdgeGroup(
	esc_html__( "Border Style", 'hudson' ),
	esc_html__( "Define style for border top on pagination", 'hudson' )
);
$blog_pagination_border_container->addChild(
	"group18",
	$group18
);

$row1 = new HudsonEdgeRow();
$group18->addChild(
	"row1",
	$row1
);

$blog_pgn_border_color = new HudsonEdgeField(
	"colorsimple",
	"blog_pgn_border_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_pgn_border_color",
	$blog_pgn_border_color
);

$blog_pgn_border_width = new HudsonEdgeField(
	"textsimple",
	"blog_pgn_border_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_pgn_border_width",
	$blog_pgn_border_width
);

$blog_pgn_border_style = new HudsonEdgeField(
	"selectsimple",
	"blog_pgn_border_style",
	"",
	esc_html__( "Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' )
	)
);
$row1->addChild(
	"blog_pgn_border_style",
	$blog_pgn_border_style
);

$blog_pagination_border_margin = new HudsonEdgeField(
	"text",
	"blog_pagination_border_margin",
	"",
	esc_html__( "Margin from Border (px)", 'hudson' ),
	esc_html__( "Set margin from border to pagination buttons", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_pagination_border_container->addChild(
	"blog_pagination_border_margin",
	$blog_pagination_border_margin
);

$number_of_chars = new HudsonEdgeField(
	"text",
	"number_of_chars",
	"45",
	esc_html__( "Number of Words in Excerpt", 'hudson' ),
	' Enter a number of words in excerpt (article summary)',
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"number_of_chars",
	$number_of_chars
);

// Blog Single

$panel20 = new HudsonEdgePanel(
	esc_html__( "Blog Single", 'hudson' ),
	"blog_single_panel"
);
$blogPage->addChild(
	"panel20",
	$panel20
);

$blog_single_sidebar = new HudsonEdgeField(
	"select",
	"blog_single_sidebar",
	"default",
	esc_html__( "Sidebar Layout", 'hudson' ),
	esc_html__( "Choose a sidebar layout for Blog Single pages", 'hudson' ),
	array(
		"default" => esc_html__( "No Sidebar", 'hudson' ),
		"1" => esc_html__( "Sidebar 1/3 right", 'hudson' ),
		"2" => esc_html__( "Sidebar 1/4 right", 'hudson' ),
		"3" => esc_html__( "Sidebar 1/3 left", 'hudson' ),
		"4" => esc_html__( "Sidebar 1/4 left", 'hudson' )
	)
);
$panel20->addChild(
	"blog_single_sidebar",
	$blog_single_sidebar
);

$custom_sidebars = hudson_edge_get_custom_sidebars();

$blog_single_sidebar_custom_display = new HudsonEdgeField(
	"selectblank",
	"blog_single_sidebar_custom_display",
	"",
	esc_html__( "Sidebar to Display", 'hudson' ),
	esc_html__( "Choose a sidebar to display on Blog Single pages", 'hudson' ),
	$custom_sidebars
);
$panel20->addChild(
	"blog_single_sidebar_custom_display",
	$blog_single_sidebar_custom_display
);

$blog_single_image_size = new HudsonEdgeField(
	"select",
	"blog_single_image_size",
	"full",
	esc_html__( "Blog Image Size", 'hudson' ),
	esc_html__( "Choose image size for Blog Single pages", 'hudson' ),
	array(
		"full" => esc_html__( "Default", 'hudson' ),
		"portfolio-landscape" => esc_html__( "Landscape", 'hudson' ),
		"portfolio-portrait" => esc_html__( "Portrait", 'hudson' ),
		"custom" => esc_html__( "Custom", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"full"                => "#edgtf_blog_single_image_size_container",
			"portfolio-landscape" => "#edgtf_blog_single_image_size_container",
			"portfolio-portrait"  => "#edgtf_blog_single_image_size_container",
			"custom"              => ""
		),
		"show"       => array(
			"full"                => "",
			"portfolio-landscape" => "",
			"portfolio-portrait"  => "",
			"custom"              => "#edgtf_blog_single_image_size_container"
		)
	)
);
$panel20->addChild(
	"blog_single_image_size",
	$blog_single_image_size
);

$blog_single_image_size_container = new HudsonEdgeContainer(
	"blog_single_image_size_container",
	"blog_single_image_size",
	"",
	array( "full", "portfolio-landscape", "portfolio-portrait" )
);
$panel20->addChild(
	"blog_single_image_size_container",
	$blog_single_image_size_container
);

$blog_single_image_size_height = new HudsonEdgeField(
	"text",
	"blog_single_image_size_height",
	"",
	esc_html__( "Image Height (px)", 'hudson' ),
	esc_html__( "Enter width (in pixels) for Custom Image for Blog Single", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_single_image_size_container->addChild(
	"blog_single_image_size_height",
	$blog_single_image_size_height
);

$blog_single_image_size_width = new HudsonEdgeField(
	"text",
	"blog_single_image_size_width",
	"",
	esc_html__( "Image Width (px)", 'hudson' ),
	esc_html__( "Enter width (in pixels) for Custom Image for Blog Single", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_single_image_size_container->addChild(
	"blog_single_image_size_width",
	$blog_single_image_size_width
);

$blog_single_show_ql_icon = new HudsonEdgeField(
	"yesno",
	"blog_single_show_ql_icon",
	"yes",
	esc_html__( "Enable Quote/Link Icon", 'hudson' ),
	esc_html__( "Enabling this option will show Quote/Link Icon on Blog Single posts", 'hudson' )
);
$panel20->addChild(
	"blog_single_show_ql_icon",
	$blog_single_show_ql_icon
);

$blog_single_navigation = new HudsonEdgeField(
	"yesno",
	"blog_single_navigation",
	"no",
	esc_html__( "Enable Prev/Next Single Post Navigation Links", 'hudson' ),
	esc_html__( "Enable navigation links through the blog posts (left and right arrows will appear)", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_hide_pagination_container"
	)
);
$panel20->addChild(
	"blog_single_navigation",
	$blog_single_navigation
);

$blog_hide_pagination_container = new HudsonEdgeContainer(
	"blog_hide_pagination_container",
	"blog_single_navigation",
	"no"
);
$panel20->addChild(
	"blog_hide_pagination_container",
	$blog_hide_pagination_container
);

$blog_navigation_through_same_category = new HudsonEdgeField(
	"yesno",
	"blog_navigation_through_same_category",
	"no",
	esc_html__( "Enable Navigation Only in Current Category", 'hudson' ),
	esc_html__( "Limit your navigation only through current category", 'hudson' )
);
$blog_hide_pagination_container->addChild(
	"blog_navigation_through_same_category",
	$blog_navigation_through_same_category
);

$blog_single_title_tags = new HudsonEdgeField(
	"select",
	"blog_single_title_tags",
	"h5",
	esc_html__( "Headlines Below Post Content", 'hudson' ),
	esc_html__( 'Choose a tag for headlines below post content ("Tags", "Post a comment", etc)', 'hudson' ),
	array(
		"h2" => esc_html__( "h2", 'hudson' ),
		"h3" => esc_html__( "h3", 'hudson' ),
		"h4" => esc_html__( "h4", 'hudson' ),
		"h5" => esc_html__( "h5", 'hudson' ),
		"h6" => esc_html__( "h6", 'hudson' )
	)
);
$panel20->addChild(
	"blog_single_title_tags",
	$blog_single_title_tags
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Blog Single Spacing", 'hudson' ),
	esc_html__( "Set spacing for single post pages", 'hudson' )
);
$panel20->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$blog_single_tags_holder_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_single_tags_holder_margin_top",
	"",
	esc_html__( "Margin Above Tags(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_tags_holder_margin_top",
	$blog_single_tags_holder_margin_top
);

$blog_single_navigation_margin = new HudsonEdgeField(
	"textsimple",
	"blog_single_navigation_margin",
	"",
	esc_html__( "Margin Above and Under Navigation(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_navigation_margin",
	$blog_single_navigation_margin
);

$blog_single_comments_holder_margin = new HudsonEdgeField(
	"textsimple",
	"blog_single_comments_holder_margin",
	"",
	esc_html__( "Margin Above and Under Comments(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_comments_holder_margin",
	$blog_single_comments_holder_margin
);

$post_info_data_single = new HudsonEdgeTitle(
	"post_info_data_single",
	esc_html__( "Post Info Data Fields", 'hudson' )
);
$panel20->addChild(
	"post_info_data_single",
	$post_info_data_single
);

$blog_single_show_date = new HudsonEdgeField(
	"yesno",
	"blog_single_show_date",
	"yes",
	esc_html__( "Show Date", 'hudson' ),
	esc_html__( "Enabling this option will show date on Blog Single posts", 'hudson' )
);
$panel20->addChild(
	"blog_single_show_date",
	$blog_single_show_date
);

$blog_single_show_like = new HudsonEdgeField(
	"yesno",
	"blog_single_show_like",
	"no",
	esc_html__( "Show Like", 'hudson' ),
	esc_html__( "Enabling this option will turn on 'Likes' on Blog Single posts", 'hudson' )
);
$panel20->addChild(
	"blog_single_show_like",
	$blog_single_show_like
);

$blog_single_show_social_share = new HudsonEdgeField(
	"yesno",
	"blog_single_show_social_share",
	"yes",
	esc_html__( "Show Share", 'hudson' ),
	esc_html__( "Enabling this option will show share on Single Post", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_single_share_options_container"
	)
);
$panel20->addChild(
	"blog_single_show_social_share",
	$blog_single_show_social_share
);

$blog_single_share_options_container = new HudsonEdgeContainer(
	"blog_single_share_options_container",
	"blog_single_show_social_share",
	"no"
);
$panel20->addChild(
	"blog_single_share_options_container",
	$blog_single_share_options_container
);

$blog_single_show_category = new HudsonEdgeField(
	"yesno",
	"blog_single_show_category",
	"yes",
	esc_html__( "Show Category", 'hudson' ),
	esc_html__( "Enabling this option will show category/categories on Blog Single posts", 'hudson' )
);
$panel20->addChild(
	"blog_single_show_category",
	$blog_single_show_category
);

$blog_author_info = new HudsonEdgeField(
	"yesno",
	"blog_author_info",
	"no",
	esc_html__( "Show Author Info", 'hudson' ),
	esc_html__( "Enabling this option will display author name and descriptions on Blog Single pages", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_blog_author_info_container"
	)
);
$panel20->addChild(
	"blog_author_info",
	$blog_author_info
);

$enable_blog_author_info_container = new HudsonEdgeContainer(
	"enable_blog_author_info_container",
	"blog_author_info",
	"no"
);
$panel20->addChild(
	"enable_blog_author_info_container",
	$enable_blog_author_info_container
);

$enable_author_info_email = new HudsonEdgeField(
	"yesno",
	"enable_author_info_email",
	"no",
	esc_html__( "Show Author Email", 'hudson' ),
	esc_html__( "Enabling this option will show author email", 'hudson' )
);
$enable_blog_author_info_container->addChild(
	"enable_author_info_email",
	$enable_author_info_email
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Blog Single Author Info Box Style", 'hudson' ),
	esc_html__( "Set styles for author info box on single post pages", 'hudson' )
);
$enable_blog_author_info_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$blog_single_post_author_info_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_margin_top",
	"",
	esc_html__( "Margin Top for Author Info Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_margin_top",
	$blog_single_post_author_info_margin_top
);

$blog_single_post_author_info_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_author_info_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_background_color",
	$blog_single_post_author_info_background_color
);

$blog_single_post_author_info_border_width = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_border_width",
	"",
	esc_html__( "Border width(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_border_width",
	$blog_single_post_author_info_border_width
);

$blog_single_post_author_info_border_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_author_info_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_border_color",
	$blog_single_post_author_info_border_color
);

$row2 = new HudsonEdgeRow();
$group1->addChild(
	"row2",
	$row2
);

$blog_single_post_author_info_padding_top = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_padding_top",
	"",
	esc_html__( "Padding Top (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_author_info_padding_top",
	$blog_single_post_author_info_padding_top
);

$blog_single_post_author_info_padding_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_padding_bottom",
	"",
	esc_html__( "Padding Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_author_info_padding_bottom",
	$blog_single_post_author_info_padding_bottom
);

$blog_single_post_author_info_padding_left = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_author_info_padding_left",
	$blog_single_post_author_info_padding_left
);

$blog_single_post_author_info_padding_right = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_author_info_padding_right",
	$blog_single_post_author_info_padding_right
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Blog Single Author Info Title Style", 'hudson' ),
	esc_html__( "Set styles for author info title on single post pages", 'hudson' )
);
$enable_blog_author_info_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$blog_single_post_author_info_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_author_info_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_title_color",
	$blog_single_post_author_info_title_color
);

$blog_single_post_author_info_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_single_post_author_info_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_title_font_family",
	$blog_single_post_author_info_title_font_family
);

$blog_single_post_author_info_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_title_fontsize",
	$blog_single_post_author_info_title_fontsize
);

$blog_single_post_author_info_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_title_lineheight",
	$blog_single_post_author_info_title_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$blog_single_post_author_info_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_single_post_author_info_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_single_post_author_info_title_fontstyle",
	$blog_single_post_author_info_title_fontstyle
);

$blog_single_post_author_info_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_single_post_author_info_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_single_post_author_info_title_fontweight",
	$blog_single_post_author_info_title_fontweight
);

$blog_single_post_author_info_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_single_post_author_info_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_single_post_author_info_title_texttransform",
	$blog_single_post_author_info_title_texttransform
);

$blog_single_post_author_info_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_author_info_title_letterspacing",
	$blog_single_post_author_info_title_letterspacing
);

$row3 = new HudsonEdgeRow();
$group2->addChild(
	"row3",
	$row3
);

$blog_single_post_author_info_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_title_margin_bottom",
	"",
	esc_html__( "Margin Bottom for Author Info Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_single_post_author_info_title_margin_bottom",
	$blog_single_post_author_info_title_margin_bottom
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Blog Single Author Info Text Style", 'hudson' ),
	esc_html__( "Set styles for author info text on single post pages", 'hudson' )
);
$enable_blog_author_info_container->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$blog_single_post_author_info_text_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_author_info_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_text_color",
	$blog_single_post_author_info_text_color
);

$blog_single_post_author_info_text_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_single_post_author_info_text_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_text_font_family",
	$blog_single_post_author_info_text_font_family
);

$blog_single_post_author_info_text_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_text_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_text_fontsize",
	$blog_single_post_author_info_text_fontsize
);

$blog_single_post_author_info_text_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_text_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_author_info_text_lineheight",
	$blog_single_post_author_info_text_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);

$blog_single_post_author_info_text_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_single_post_author_info_text_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_single_post_author_info_text_fontstyle",
	$blog_single_post_author_info_text_fontstyle
);

$blog_single_post_author_info_text_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_single_post_author_info_text_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_single_post_author_info_text_fontweight",
	$blog_single_post_author_info_text_fontweight
);

$blog_single_post_author_info_text_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_single_post_author_info_text_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_single_post_author_info_text_texttransform",
	$blog_single_post_author_info_text_texttransform
);

$blog_single_post_author_info_text_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_author_info_text_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_author_info_text_letterspacing",
	$blog_single_post_author_info_text_letterspacing
);

$blog_single_show_comments = new HudsonEdgeField(
	"yesno",
	"blog_single_show_comments",
	"yes",
	esc_html__( "Show Comments", 'hudson' ),
	esc_html__( "Enabling this option will show comments on Blog Single posts", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_blog_comments_container"
	)
);
$panel20->addChild(
	"blog_single_show_comments",
	$blog_single_show_comments
);

$enable_blog_comments_container = new HudsonEdgeContainer(
	"enable_blog_comments_container",
	"blog_single_show_comments",
	"no"
);
$panel20->addChild(
	"enable_blog_comments_container",
	$enable_blog_comments_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Comments Box Style", 'hudson' ),
	esc_html__( "Set styles for comments box on single post pages", 'hudson' )
);
$enable_blog_comments_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$blog_single_post_comments_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_comments_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_background_color",
	$blog_single_post_comments_background_color
);

$blog_single_post_comments_border_width = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_comments_border_width",
	"",
	esc_html__( "Border width(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_border_width",
	$blog_single_post_comments_border_width
);

$blog_single_post_comments_border_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_comments_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_border_color",
	$blog_single_post_comments_border_color
);

$blog_single_post_comments_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_comments_margin_bottom",
	"",
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_margin_bottom",
	$blog_single_post_comments_margin_bottom
);

$row2 = new HudsonEdgeRow();
$group1->addChild(
	"row2",
	$row2
);

$blog_single_post_comments_padding_top = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_comments_padding_top",
	"",
	esc_html__( "Padding Top (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_comments_padding_top",
	$blog_single_post_comments_padding_top
);

$blog_single_post_comments_padding_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_comments_padding_bottom",
	"",
	esc_html__( "Padding Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_comments_padding_bottom",
	$blog_single_post_comments_padding_bottom
);

$blog_single_post_comments_padding_left = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_comments_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_comments_padding_left",
	$blog_single_post_comments_padding_left
);

$blog_single_post_comments_padding_right = new HudsonEdgeField(
	"textsimple",
	"blog_single_post_comments_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_single_post_comments_padding_right",
	$blog_single_post_comments_padding_right
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Comments Color Style", 'hudson' ),
	esc_html__( "Set styles for comments on single post pages", 'hudson' )
);
$enable_blog_comments_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$blog_single_post_comments_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_comments_title_color",
	"",
	esc_html__( "Title Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_title_color",
	$blog_single_post_comments_title_color
);

$blog_single_post_comments_text_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_comments_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_text_color",
	$blog_single_post_comments_text_color
);

$blog_single_post_comments_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_comments_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_link_color",
	$blog_single_post_comments_link_color
);

$blog_single_post_comments_date_color = new HudsonEdgeField(
	"colorsimple",
	"blog_single_post_comments_date_color",
	"",
	esc_html__( "Date Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_single_post_comments_date_color",
	$blog_single_post_comments_date_color
);

$blog_single_enable_pattern = new HudsonEdgeField(
	"yesno",
	"blog_single_enable_pattern",
	"yes",
	esc_html__( "Enable Pattern on Post Info", 'hudson' ),
	esc_html__( "Enable this option to show pattern on date, comments and share holders", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_show_on_yes" => "#edgtf_blog_single_pattern_container",
		"dependence_hide_on_yes" => ""
	)
);
$panel20->addChild(
	"blog_single_enable_pattern",
	$blog_single_enable_pattern
);

$blog_single_pattern_container = new HudsonEdgeContainer(
	"blog_single_pattern_container",
	"blog_single_enable_pattern",
	"no"
);
$panel20->addChild(
	"blog_single_pattern_container",
	$blog_single_pattern_container
);

$blog_single_info_pattern = new HudsonEdgeField(
	"image",
	"blog_single_info_pattern",
	"",
	esc_html__( "Pattern", 'hudson' ),
	esc_html__( "Choose a pattern", 'hudson' )
);
$blog_single_pattern_container->addChild(
	"blog_single_info_pattern",
	$blog_single_info_pattern
);

// Advanced Options

$panel_advanced_options = new HudsonEdgePanel(
	esc_html__( "Advanced Options", 'hudson' ),
	"panel_advanced_options"
);
$blogPage->addChild(
	"panel_advanced_options",
	$panel_advanced_options
);

$blog_standard_type_show_options = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_options",
	"no",
	esc_html__( "Show Standard Template Options", 'hudson' ),
	esc_html__( "Editing these options will have affect on Post List & Single Post", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_post_lists"
	)
);
$panel_advanced_options->addChild(
	"blog_standard_type_show_options",
	$blog_standard_type_show_options
);

$blog_masonry_show_options = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_options",
	"no",
	esc_html__( "Show Masonry & Masonry Full Width Template Options", 'hudson' ),
	esc_html__( "Editing these options will have affect on Post List & Single Post", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_post_lists"
	)
);
$panel_advanced_options->addChild(
	"blog_masonry_show_options",
	$blog_masonry_show_options
);

$blog_masonry_gallery_show_options = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_options",
	"no",
	esc_html__( "Show Masonry Gallery and Masonry Gallery Full Width Template Options", 'hudson' ),
	esc_html__( "Editing these options will have affect on Post List & Single Post", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_gallery_post_lists"
	)
);
$panel_advanced_options->addChild(
	"blog_masonry_gallery_show_options",
	$blog_masonry_gallery_show_options
);

$blog_vertical_loop_show_options = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_show_options",
	"no",
	esc_html__( "Show Vertical Loop Template Options", 'hudson' ),
	esc_html__( "Editing these options will have affect on Post List & Single Post", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_vertical_loop_post_lists"
	)
);
$panel_advanced_options->addChild(
	"blog_vertical_loop_show_options",
	$blog_vertical_loop_show_options
);

// Blog Post List - Blog: Masonry
$panel10 = new HudsonEdgePanel(
	esc_html__( "Blog List Templates Options: Masonry & Masonry Full Width", 'hudson' ),
	"blog_masonry_post_lists",
	"blog_masonry_show_options",
	"no"
);
$blogPage->addChild(
	"panel10",
	$panel10
);

$blog_masonry_number_of_chars = new HudsonEdgeField(
	"text",
	"blog_masonry_number_of_chars",
	"45",
	esc_html__( "Number of Words in Excerpt", 'hudson' ),
	' Enter a number of words in excerpt (article summary)',
	array(),
	array( "col_width" => 3 )
);
$panel10->addChild(
	"blog_masonry_number_of_chars",
	$blog_masonry_number_of_chars
);

$blog_masonry_read_more_button = new HudsonEdgeField(
	"yesno",
	"blog_masonry_read_more_button",
	"no",
	esc_html__( "Read More Button", 'hudson' ),
	esc_html__( "Enable Read More Button", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_read_more_button_container"
	)
);
$panel10->addChild(
	"blog_masonry_read_more_button",
	$blog_masonry_read_more_button
);

$blog_masonry_read_more_button_container = new HudsonEdgeContainer(
	"blog_masonry_read_more_button_container",
	"blog_masonry_read_more_button",
	"no"
);
$panel10->addChild(
	"blog_masonry_read_more_button_container",
	$blog_masonry_read_more_button_container
);

$blog_masonry_read_more_button_icon = new HudsonEdgeField(
	"yesno",
	"blog_masonry_read_more_button_icon",
	"no",
	esc_html__( "Enable Icon", 'hudson' ),
	esc_html__( "Enabling this option will place icon in read more button", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_read_more_button_icon_container"
	)
);
$blog_masonry_read_more_button_container->addChild(
	"blog_masonry_read_more_button_icon",
	$blog_masonry_read_more_button_icon
);

$blog_masonry_read_more_button_icon_container = new HudsonEdgeContainer(
	"blog_masonry_read_more_button_icon_container",
	"blog_masonry_read_more_button_icon",
	"no"
);
$blog_masonry_read_more_button_container->addChild(
	"blog_masonry_read_more_button_icon_container",
	$blog_masonry_read_more_button_icon_container
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$blog_masonry_read_more_button_icon_pack_hide_array = array();
$blog_masonry_read_more_button_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$blog_masonry_read_more_button_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$blog_masonry_read_more_button_icon_pack_hide_array[ $dep_collection_key ] = '';
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$blog_masonry_read_more_button_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_blog_masonry_read_more_button_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $blog_masonry_read_more_button_icon_collections_params as $blog_masonry_read_more_button_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $blog_masonry_read_more_button_icon_collections_param !== $dep_collection_object->param ) {
				$blog_masonry_read_more_button_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_blog_masonry_read_more_button_icon_' . $blog_masonry_read_more_button_icon_collections_param . '_container,';
			}
		}
		
		//remove remaining ',' character
		$blog_masonry_read_more_button_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$blog_masonry_read_more_button_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$blog_masonry_read_more_button_icon_pack = new HudsonEdgeField(
	"select",
	"blog_masonry_read_more_button_icon_pack",
	"font_awesome",
	esc_html__( "Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for show load more button", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		"dependence" => true,
		"hide"       => $blog_masonry_read_more_button_icon_pack_hide_array,
		"show"       => $blog_masonry_read_more_button_icon_pack_show_array
	)
);

$blog_masonry_read_more_button_icon_container->addChild(
	"blog_masonry_read_more_button_icon_pack",
	$blog_masonry_read_more_button_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$blog_masonry_read_more_button_icon_hide_values = $icon_collections_keys;
		$blog_icon_container                            = new HudsonEdgeContainer(
			"blog_masonry_read_more_button_icon_" . $collection_object->param . "_container",
			"blog_masonry_read_more_button_icon_pack",
			"",
			$blog_masonry_read_more_button_icon_hide_values
		);
		$blog_masonry_read_more_button_icon             = new HudsonEdgeField(
			"select",
			"blog_masonry_read_more_button_icon_" . $collection_object->param,
			"",
			esc_html__( "Button Icon", 'hudson' ),
			esc_html__( "Choose Button Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$blog_icon_container->addChild(
			"blog_masonry_read_more_button_icon_" . $collection_object->param,
			$blog_masonry_read_more_button_icon
		);
		
		$blog_masonry_read_more_button_icon_container->addChild(
			"blog_masonry_read_more_button_icon_" . $collection_object->param . "_container",
			$blog_icon_container
		);
	}
	
}

$pagination_masonry = new HudsonEdgeField(
	"select",
	"pagination_masonry",
	"pagination",
	esc_html__( "Pagination on Masonry", 'hudson' ),
	esc_html__( 'Choose a pagination style for "Masonry" Blog List', 'hudson' ),
	array(
		"pagination" => esc_html__( "Pagination", 'hudson' ),
		"load_more" => esc_html__( "Load More", 'hudson' ),
		"infinite_scroll" => esc_html__( "Infinite Scroll", 'hudson' )
	)
);
$panel10->addChild(
	"pagination_masonry",
	$pagination_masonry
);

$blog_masonry_columns = new HudsonEdgeField(
	'select',
	'blog_masonry_columns',
	'',
	esc_html__( 'Masonry Blog Columns', 'hudson' ),
	esc_html__( 'Choose a number of columns for "Masonry" Blog List without sidebar', 'hudson' ),
	array(
		'two_columns'   => '2',
		'three_columns' => '3'
	)
);
$panel10->addChild(
	'blog_masonry_columns',
	$blog_masonry_columns
);

$blog_masonry_full_width_columns = new HudsonEdgeField(
	'select',
	'blog_masonry_full_width_columns',
	'',
	esc_html__( 'Full Width Masonry Blog Columns', 'hudson' ),
	esc_html__( 'Choose a number of columns for "Masonry" Blog List', 'hudson' ),
	array(
		'three_columns' => '3',
		'four_columns'  => '4',
		'five_columns'  => '5'
	)
);
$panel10->addChild(
	'blog_masonry_full_width_columns',
	$blog_masonry_full_width_columns
);

$blog_masonry_full_width_margin = new HudsonEdgeField(
	"text",
	"blog_masonry_full_width_margin",
	"",
	esc_html__( "Full Width Masonry Margin", 'hudson' ),
	esc_html__( 'Please insert margin in px (i.e. 5px), or in % (i.e 5%)', 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel10->addChild(
	"blog_masonry_full_width_margin",
	$blog_masonry_full_width_margin
);

$blog_masonry_filter = new HudsonEdgeField(
	"yesno",
	"blog_masonry_filter",
	"no",
	esc_html__( "Show Category Filter on Masonry", 'hudson' ),
	esc_html__( 'Enabling this option will display a Category Filter on "Masonry" Blog List', 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_filter_container"
	)
);
$panel10->addChild(
	"blog_masonry_filter",
	$blog_masonry_filter
);

$blog_masonry_filter_container = new HudsonEdgeContainer(
	"blog_masonry_filter_container",
	"blog_masonry_filter",
	"no"
);
$panel10->addChild(
	"blog_masonry_filter_container",
	$blog_masonry_filter_container
);

// Blog Masonry Filter
$blog_masonry_filter_background_color = new HudsonEdgeField(
	"color",
	"blog_masonry_filter_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose color for background of filter area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_filter_container->addChild(
	"blog_masonry_filter_background_color",
	$blog_masonry_filter_background_color
);

$blog_masonry_filter_height = new HudsonEdgeField(
	"text",
	"blog_masonry_filter_height",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "Enter height for filter area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_filter_container->addChild(
	"blog_masonry_filter_height",
	$blog_masonry_filter_height
);

$blog_masonry_filter_margin_bottom = new HudsonEdgeField(
	"text",
	"blog_masonry_filter_margin_bottom",
	"",
	esc_html__( "Bottom Margin (px)", 'hudson' ),
	esc_html__( "Enter bottom margin for filter area. Default value is 36", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_filter_container->addChild(
	"blog_masonry_filter_margin_bottom",
	$blog_masonry_filter_margin_bottom
);

$blog_masonry_filter_alignment = new HudsonEdgeField(
	"select",
	"blog_masonry_filter_alignment",
	"",
	esc_html__( "Horizontal Alignment", 'hudson' ),
	esc_html__( "Choose filter alignment", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$blog_masonry_filter_container->addChild(
	"blog_masonry_filter_alignment",
	$blog_masonry_filter_alignment
);

$blog_masonry_enable_filter_title = new HudsonEdgeField(
	"yesno",
	"blog_masonry_enable_filter_title",
	"no",
	esc_html__( "Enable Filter Title", 'hudson' ),
	esc_html__( "Enabling this option will show category filter title", 'hudson' )
);
$blog_masonry_filter_container->addChild(
	"blog_masonry_enable_filter_title",
	$blog_masonry_enable_filter_title
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Title", 'hudson' ),
	esc_html__( "Define text styles for filter title", 'hudson' )
);
$blog_masonry_filter_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$blog_masonry_filter_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_filter_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_title_color",
	$blog_masonry_filter_title_color
);
$blog_masonry_filter_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_filter_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_title_font_size",
	$blog_masonry_filter_title_font_size
);
$blog_masonry_filter_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_filter_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_title_line_height",
	$blog_masonry_filter_title_line_height
);
$blog_masonry_filter_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_filter_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"blog_masonry_filter_title_text_transform",
	$blog_masonry_filter_title_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);
$blog_masonry_filter_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_filter_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_filter_title_font_family",
	$blog_masonry_filter_title_font_family
);
$blog_masonry_filter_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_filter_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_filter_title_font_style",
	$blog_masonry_filter_title_font_style
);
$blog_masonry_filter_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_filter_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_filter_title_font_weight",
	$blog_masonry_filter_title_font_weight
);
$blog_masonry_filter_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_filter_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_filter_title_letter_spacing",
	$blog_masonry_filter_title_letter_spacing
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Categories", 'hudson' ),
	esc_html__( "Define text styles for filter categories", 'hudson' )
);
$blog_masonry_filter_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);
$blog_masonry_filter_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_filter_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_color",
	$blog_masonry_filter_color
);
$blog_masonry_filter_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_filter_hovercolor",
	"",
	esc_html__( "Hover/Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_hovercolor",
	$blog_masonry_filter_hovercolor
);
$blog_masonry_filter_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_filter_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_font_size",
	$blog_masonry_filter_font_size
);
$blog_masonry_filter_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_filter_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_filter_line_height",
	$blog_masonry_filter_line_height
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);
$blog_masonry_filter_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_filter_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_filter_font_family",
	$blog_masonry_filter_font_family
);
$blog_masonry_filter_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_filter_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_filter_font_style",
	$blog_masonry_filter_font_style
);
$blog_masonry_filter_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_filter_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_filter_font_weight",
	$blog_masonry_filter_font_weight
);
$blog_masonry_filter_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_filter_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_masonry_filter_text_transform",
	$blog_masonry_filter_text_transform
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);
$blog_masonry_filter_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_filter_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_filter_letter_spacing",
	$blog_masonry_filter_letter_spacing
);

$blog_masonry_filter_disable_separator = new HudsonEdgeField(
	"yesno",
	"blog_masonry_filter_disable_separator",
	"yes",
	esc_html__( "Disable Separator Between Categories", 'hudson' ),
	esc_html__( "Disabling this option will remove separator between filter categories.", 'hudson' )
);
$blog_masonry_filter_container->addChild(
	"blog_masonry_filter_disable_separator",
	$blog_masonry_filter_disable_separator
);

$blog_masonry_type = new HudsonEdgeField(
	"select",
	"blog_masonry_type",
	"post_info_below_title",
	esc_html__( "Post Info Position", 'hudson' ),
	esc_html__( "Choose Post Info Position for Masonry Blog List", 'hudson' ),
	array(
		"post_info_below_title" => esc_html__( "Post Info Section Below Title", 'hudson' ),
		"post_info_at_bottom" => esc_html__( "Post Info Section at Bottom", 'hudson' )
	)
);
$panel10->addChild(
	"blog_masonry_type",
	$blog_masonry_type
);

$blog_masonry_content_position = new HudsonEdgeField(
	"select",
	"blog_masonry_content_position",
	"content_above_blog_list",
	esc_html__( "Content Position", 'hudson' ),
	esc_html__( "Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", 'hudson' ),
	array(
		"content_above_blog_list" => esc_html__( "Content Above Blog List", 'hudson' ),
		"content_above_blog_list_and_sidebar" => esc_html__( "Content Above Blog List and Sidebar", 'hudson' )
	)
);
$panel10->addChild(
	"blog_masonry_content_position",
	$blog_masonry_content_position
);

$blog_masonry_post_meta_data_section = new HudsonEdgeTitle(
	"blog_masonry_post_meta_data_section",
	esc_html__( "Post Info Data Fields", 'hudson' )
);
$panel10->addChild(
	"blog_masonry_post_meta_data_section",
	$blog_masonry_post_meta_data_section
);

$blog_masonry_show_categories = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_categories",
	"no",
	esc_html__( "Show Categories", 'hudson' ),
	esc_html__( "Enabling this option will Show Categories on Post List", 'hudson' )
);
$panel10->addChild(
	"blog_masonry_show_categories",
	$blog_masonry_show_categories
);

$blog_masonry_show_comments = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_comments",
	"no",
	esc_html__( "Show Comments", 'hudson' ),
	esc_html__( "Enabling this option will Show Comments on Post List", 'hudson' )
);
$panel10->addChild(
	"blog_masonry_show_comments",
	$blog_masonry_show_comments
);

$blog_masonry_show_author = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_author",
	"no",
	esc_html__( "Show Author Name", 'hudson' ),
	esc_html__( "Enabling this option will show author name on Post List and Blog Post Single", 'hudson' )
);
$panel10->addChild(
	"blog_masonry_show_author",
	$blog_masonry_show_author
);

$blog_masonry_show_date = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_date",
	"no",
	esc_html__( "Show Date", 'hudson' ),
	esc_html__( "Enabling this option will show date on Post List", 'hudson' )
);
$panel10->addChild(
	"blog_masonry_hide_date",
	$blog_masonry_show_date
);

$blog_masonry_show_share = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_share",
	"no",
	esc_html__( "Show Share", 'hudson' ),
	esc_html__( "Enabling this option will show share on Post List", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_share_options_container"
	)
);
$panel10->addChild(
	"blog_masonry_show_share",
	$blog_masonry_show_share
);

$blog_masonry_share_options_container = new HudsonEdgeContainer(
	"blog_masonry_share_options_container",
	"blog_masonry_show_share",
	"no"
);
$panel10->addChild(
	"blog_masonry_share_options_container",
	$blog_masonry_share_options_container
);

$blog_masonry_select_share_options_masonry_type = new HudsonEdgeField(
	"select",
	"blog_masonry_select_share_options_masonry_type",
	"dropdown",
	esc_html__( "Social Share Style", 'hudson' ),
	esc_html__( "Choose Social Share Style for Masonry Type", 'hudson' ),
	array(
		"dropdown" => esc_html__( "Social Share Dropdown", 'hudson' ),
		"list" => esc_html__( "Social Share List", 'hudson' )
	),
	array(
		"dependence" => true,
		"show"       => array(
			"list"     => "#edgtf_blog_masonry_share_list_type_options_container",
			"dropdown" => "#edgtf_blog_masonry_share_dropdown_type_options_container"
		),
		"hide"       => array(
			"dropdown" => "#edgtf_blog_masonry_share_list_type_options_container",
			"list"     => "#edgtf_blog_masonry_share_dropdown_type_options_container"
		),
	)
);

$blog_masonry_share_options_container->addChild(
	"blog_masonry_select_share_options_masonry_type",
	$blog_masonry_select_share_options_masonry_type
);

$blog_masonry_share_list_type_options_container = new HudsonEdgeContainer(
	"blog_masonry_share_list_type_options_container",
	"blog_masonry_select_share_options_masonry_type",
	"dropdown"
);
$blog_masonry_share_options_container->addChild(
	"blog_masonry_share_list_type_options_container",
	$blog_masonry_share_list_type_options_container
);

$blog_masonry_share_hld_hover_icon_color = new HudsonEdgeField(
	"color",
	"blog_masonry_share_hld_hover_icon_color",
	"",
	esc_html__( "Icon color on Quote/Link Holder Hover", 'hudson' ),
	esc_html__( "Choose icon color for share list when the quote/link holder is hovered over", 'hudson' )
);
$blog_masonry_share_list_type_options_container->addChild(
	"blog_masonry_share_hld_hover_icon_color",
	$blog_masonry_share_hld_hover_icon_color
);

$blog_masonry_share_dropdown_type_options_container = new HudsonEdgeContainer(
	"blog_masonry_share_dropdown_type_options_container",
	"blog_masonry_select_share_options_masonry_type",
	"list"
);
$blog_masonry_share_options_container->addChild(
	"blog_masonry_share_dropdown_type_options_container",
	$blog_masonry_share_dropdown_type_options_container
);

$blog_masonry_share_background_color = new HudsonEdgeField(
	"color",
	"blog_masonry_share_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for share dropdown", 'hudson' )
);
$blog_masonry_share_dropdown_type_options_container->addChild(
	"blog_masonry_share_background_color",
	$blog_masonry_share_background_color
);

$blog_masonry_share_background_color_link_post_type = new HudsonEdgeField(
	"color",
	"blog_masonry_share_background_color_link_post_type",
	"",
	esc_html__( "Background Color on Quote/Link Post Type", 'hudson' ),
	esc_html__( "Choose background color for share dropdown", 'hudson' )
);
$blog_masonry_share_dropdown_type_options_container->addChild(
	"blog_masonry_share_background_color_link_post_type",
	$blog_masonry_share_background_color_link_post_type
);

$blog_masonry_share_icon_color = new HudsonEdgeField(
	"color",
	"blog_masonry_share_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for share dropdown and list", 'hudson' )
);
$blog_masonry_share_options_container->addChild(
	"blog_masonry_share_icon_color",
	$blog_masonry_share_icon_color
);

$blog_masonry_share_icon_hover_color = new HudsonEdgeField(
	"color",
	"blog_masonry_share_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose icon hover color for share dropdown and list", 'hudson' )
);
$blog_masonry_share_options_container->addChild(
	"blog_masonry_share_icon_hover_color",
	$blog_masonry_share_icon_hover_color
);

$blog_masonry_share_icon_color_link_post_type = new HudsonEdgeField(
	"color",
	"blog_masonry_share_icon_color_link_post_type",
	"",
	esc_html__( "Icon Color for Quote/Link Post Type", 'hudson' ),
	esc_html__( "Choose icon color for share dropdown and list", 'hudson' )
);
$blog_masonry_share_options_container->addChild(
	"blog_masonry_share_icon_color_link_post_type",
	$blog_masonry_share_icon_color_link_post_type
);

$blog_masonry_share_icon_hover_color_link_post_type = new HudsonEdgeField(
	"color",
	"blog_masonry_share_icon_hover_color_link_post_type",
	"",
	esc_html__( "Icon Hover Color for Quote/Link Post Type", 'hudson' ),
	esc_html__( "Choose icon hover color for share dropdown and list", 'hudson' )
);
$blog_masonry_share_options_container->addChild(
	"blog_masonry_share_icon_hover_color_link_post_type",
	$blog_masonry_share_icon_hover_color_link_post_type
);

$blog_masonry_show_like = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_like",
	"no",
	esc_html__( "Show Likes", 'hudson' ),
	esc_html__( 'Enabling this option will turn on "Likes"', 'hudson' )
);
$panel10->addChild(
	"blog_masonry_show_like",
	$blog_masonry_show_like
);

$blog_masonry_post_design_style = new HudsonEdgeTitle(
	"blog_masonry_post_design_style",
	esc_html__( "Post Design Style", 'hudson' )
);
$panel10->addChild(
	"blog_masonry_post_design_style",
	$blog_masonry_post_design_style
);

$blog_masonry_post_alignment = new HudsonEdgeField(
	"select",
	"blog_masonry_post_alignment",
	"",
	esc_html__( "Post Alignment", 'hudson' ),
	esc_html__( "Choose alignment for whole post", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$panel10->addChild(
	"blog_masonry_post_alignment",
	$blog_masonry_post_alignment
);

$blog_masonry_enable_text_box = new HudsonEdgeField(
	"yesno",
	"blog_masonry_enable_text_box",
	"no",
	esc_html__( "Enable Boxed Styled Post Content", 'hudson' ),
	esc_html__( "Enable post text boxed features", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_enable_text_box_container"
	)
);
$panel10->addChild(
	"blog_masonry_enable_text_box",
	$blog_masonry_enable_text_box
);

$blog_masonry_enable_text_box_container = new HudsonEdgeContainer(
	"blog_masonry_enable_text_box_container",
	"blog_masonry_enable_text_box",
	"no"
);
$panel10->addChild(
	"blog_masonry_enable_text_box_container",
	$blog_masonry_enable_text_box_container
);

$blog_masonry_box_background_color = new HudsonEdgeField(
	"color",
	"blog_masonry_box_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for post text box", 'hudson' )
);
$blog_masonry_enable_text_box_container->addChild(
	"blog_masonry_box_background_color",
	$blog_masonry_box_background_color
);

$blog_masonry_box_border_color = new HudsonEdgeField(
	"color",
	"blog_masonry_box_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color for post text box", 'hudson' )
);
$blog_masonry_enable_text_box_container->addChild(
	"blog_masonry_box_border_color",
	$blog_masonry_box_border_color
);

$blog_masonry_box_padding = new HudsonEdgeField(
	"text",
	"blog_masonry_box_padding",
	"",
	esc_html__( "Text box padding", 'hudson' ),
	esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_enable_text_box_container->addChild(
	"blog_masonry_box_padding",
	$blog_masonry_box_padding
);

$group7 = new HudsonEdgeGroup(
	esc_html__( "Paragraph", 'hudson' ),
	esc_html__( "Set paragraph color", 'hudson' )
);
$panel10->addChild(
	"group7",
	$group7
);

$blog_masonry_paragraph_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_paragraph_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$group7->addChild(
	"blog_masonry_paragraph_color",
	$blog_masonry_paragraph_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Background", 'hudson' ),
	esc_html__( "Set background of Quote/Link post type", 'hudson' )
);
$panel10->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$blog_masonry_ql_background_image = new HudsonEdgeField(
	"yesnosimple",
	"blog_masonry_ql_background_image",
	"no",
	esc_html__( "Background Image", 'hudson' ),
	""
);
$row1->addChild(
	"blog_masonry_ql_background_image",
	$blog_masonry_ql_background_image
);

$blog_masonry_ql_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Default color is #ffffff.", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_background_color",
	$blog_masonry_ql_background_color
);

$blog_masonry_ql_hover_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_hover_background_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "Default color is #e6ae48.", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_hover_background_color",
	$blog_masonry_ql_hover_background_color
);

$blog_masonry_show_ql_mark = new HudsonEdgeField(
	"yesno",
	"blog_masonry_show_ql_mark",
	"yes",
	esc_html__( "Enable Quote/Link Icon", 'hudson' ),
	esc_html__( "Show Icons for quote/link post format", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_show_ql_mark_container"
	)
);
$panel10->addChild(
	"blog_masonry_show_ql_mark",
	$blog_masonry_show_ql_mark
);

$blog_masonry_show_ql_mark_container = new HudsonEdgeContainer(
	"blog_masonry_show_ql_mark_container",
	"blog_masonry_show_ql_mark",
	"no"
);
$panel10->addChild(
	"blog_masonry_show_ql_mark_container",
	$blog_masonry_show_ql_mark_container
);

$row1 = new HudsonEdgeRow();
$blog_masonry_show_ql_mark_container->addChild(
	"row1",
	$row1
);

$blog_masonry_ql_mark_color = new HudsonEdgeField(
	"color",
	"blog_masonry_ql_mark_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for quote/link post", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_mark_color",
	$blog_masonry_ql_mark_color
);

$blog_masonry_ql_mark_hover_color = new HudsonEdgeField(
	"color",
	"blog_masonry_ql_mark_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose hover icon color for quote/link post.", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_mark_hover_color",
	$blog_masonry_ql_mark_hover_color
);

$group8 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel10->addChild(
	"group8",
	$group8
);

$row1 = new HudsonEdgeRow();
$group8->addChild(
	"row1",
	$row1
);

$blog_masonry_image_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_image_margin_bottom",
	"",
	esc_html__( "Margin Under Image (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_image_margin_bottom",
	$blog_masonry_image_margin_bottom
);

$blog_masonry_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_title_margin_bottom",
	$blog_masonry_title_margin_bottom
);

$blog_masonry_post_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_post_info_margin_bottom",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_post_info_margin_bottom",
	$blog_masonry_post_info_margin_bottom
);

$blog_masonry_read_more_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_read_more_margin_top",
	"",
	esc_html__( "Margin Above Read More Button (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_read_more_margin_top",
	$blog_masonry_read_more_margin_top
);

$row2 = new HudsonEdgeRow();
$group8->addChild(
	"row2",
	$row2
);

$blog_masonry_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Social Share List Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_social_share_list_margin_top",
	$blog_masonry_social_share_list_margin_top
);

$blog_masonry_article_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_article_margin_bottom",
	"",
	esc_html__( "Margin Between Articles (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_article_margin_bottom",
	$blog_masonry_article_margin_bottom
);

$blog_masonry_post_info_bottom_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_post_info_bottom_margin_top",
	"",
	esc_html__( "Margin Above Post Info When Post Info is on the bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_post_info_bottom_margin_top",
	$blog_masonry_post_info_bottom_margin_top
);

$group9 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing for Quote and Link Post Type", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel10->addChild(
	"group9",
	$group9
);

$row1 = new HudsonEdgeRow();
$group9->addChild(
	"row1",
	$row1
);

$blog_masonry_ql_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_title_margin_bottom",
	$blog_masonry_ql_title_margin_bottom
);

$blog_masonry_ql_quote_author_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_quote_author_margin_bottom",
	"",
	esc_html__( "Margin Under Quote Author (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_quote_author_margin_bottom",
	$blog_masonry_ql_quote_author_margin_bottom
);

$blog_masonry_ql_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Social Share List Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_social_share_list_margin_top",
	$blog_masonry_ql_social_share_list_margin_top
);

$group10 = new HudsonEdgeGroup(
	esc_html__( "Border Arround Article", 'hudson' ),
	esc_html__( "Set border style for articles", 'hudson' )
);
$panel10->addChild(
	"group10",
	$group10
);

$row1 = new HudsonEdgeRow();
$group10->addChild(
	"row1",
	$row1
);

$blog_masonry_article_border_width = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_article_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_article_border_width",
	$blog_masonry_article_border_width
);

$blog_masonry_article_border_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_article_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_article_border_color",
	$blog_masonry_article_border_color
);

$post_text_styling = new HudsonEdgeTitle(
	"post_text_styling",
	esc_html__( "Post Text Style", 'hudson' )
);
$panel10->addChild(
	"post_text_styling",
	$post_text_styling
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Post Title", 'hudson' ),
	esc_html__( "Define title styles in this blog post template.", 'hudson' )
);
$panel10->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$blog_masonry_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_title_color",
	$blog_masonry_title_color
);

$blog_masonry_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_title_hover_color",
	$blog_masonry_title_hover_color
);

$blog_masonry_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_title_fontsize",
	$blog_masonry_title_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$blog_masonry_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_title_lineheight",
	$blog_masonry_title_lineheight
);

$blog_masonry_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_title_google_fonts",
	$blog_masonry_title_google_fonts
);

$blog_masonry_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_title_fontstyle",
	$blog_masonry_title_fontstyle
);

$blog_masonry_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_title_fontweight",
	$blog_masonry_title_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$blog_masonry_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_masonry_title_texttransform",
	$blog_masonry_title_texttransform
);

$blog_masonry_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_title_letterspacing",
	$blog_masonry_title_letterspacing
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Post Info Data", 'hudson' ),
	esc_html__( "Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list", 'hudson' )
);
$panel10->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);

$blog_masonry_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_info_color",
	$blog_masonry_info_color
);

$blog_masonry_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_info_link_color",
	$blog_masonry_info_link_color
);

$blog_masonry_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_info_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_info_hover_color",
	$blog_masonry_info_hover_color
);

$blog_masonry_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_info_fontsize",
	$blog_masonry_info_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group4->addChild(
	"row2",
	$row2
);

$blog_masonry_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_info_lineheight",
	$blog_masonry_info_lineheight
);

$blog_masonry_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_info_google_fonts",
	$blog_masonry_info_google_fonts
);

$blog_masonry_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_info_fontstyle",
	$blog_masonry_info_fontstyle
);

$blog_masonry_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_info_fontweight",
	$blog_masonry_info_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group4->addChild(
	"row3",
	$row3
);

$blog_masonry_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_masonry_info_texttransform",
	$blog_masonry_info_texttransform
);

$blog_masonry_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_info_letterspacing",
	$blog_masonry_info_letterspacing
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Title Style", 'hudson' ),
	esc_html__( "Define title styles for Quote/Link articles", 'hudson' )
);
$panel10->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$blog_masonry_ql_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_title_color",
	$blog_masonry_ql_title_color
);

$blog_masonry_ql_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_title_hover_color",
	$blog_masonry_ql_title_hover_color
);

$blog_masonry_ql_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_title_font_size",
	$blog_masonry_ql_title_fontsize
);

$blog_masonry_ql_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_title_lineheight",
	$blog_masonry_ql_title_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);

$blog_masonry_ql_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_masonry_ql_title_texttransform",
	$blog_masonry_ql_title_texttransform
);

$blog_masonry_ql_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_ql_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_ql_title_google_fonts",
	$blog_masonry_ql_title_google_fonts
);

$blog_masonry_ql_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_ql_title_fontstyle",
	$blog_masonry_ql_title_fontstyle
);

$blog_masonry_ql_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_ql_title_fontweight",
	$blog_masonry_ql_title_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group3->addChild(
	"row3",
	$row3
);

$blog_masonry_ql_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_ql_title_letterspacing",
	$blog_masonry_ql_title_letterspacing
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Post Info Data", 'hudson' ),
	esc_html__( "Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.", 'hudson' )
);
$panel10->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);

$blog_masonry_ql_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_info_color",
	$blog_masonry_ql_info_color
);

$blog_masonry_ql_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_info_link_color",
	$blog_masonry_ql_info_link_color
);

$blog_masonry_ql_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_info_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_info_hover_color",
	$blog_masonry_ql_info_hover_color
);

$blog_masonry_ql_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_info_fontsize",
	$blog_masonry_ql_info_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group5->addChild(
	"row2",
	$row2
);

$blog_masonry_ql_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_ql_info_lineheight",
	$blog_masonry_ql_info_lineheight
);

$blog_masonry_ql_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_ql_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_ql_info_google_fonts",
	$blog_masonry_ql_info_google_fonts
);

$blog_masonry_ql_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_ql_info_fontstyle",
	$blog_masonry_ql_info_fontstyle
);

$blog_masonry_ql_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_ql_info_fontweight",
	$blog_masonry_ql_info_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group5->addChild(
	"row3",
	$row3
);

$blog_masonry_ql_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_masonry_ql_info_texttransform",
	$blog_masonry_ql_info_texttransform
);

$blog_masonry_ql_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_ql_info_letterspacing",
	$blog_masonry_ql_info_letterspacing
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Quote Author Style", 'hudson' ),
	esc_html__( "Define author styles for Quote articles", 'hudson' )
);
$panel10->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$blog_masonry_ql_author_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_author_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_author_color",
	$blog_masonry_ql_author_color
);

$blog_masonry_ql_author_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_ql_author_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_author_hover_color",
	$blog_masonry_ql_author_hover_color
);

$blog_masonry_ql_author_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_author_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_author_font_size",
	$blog_masonry_ql_author_fontsize
);

$blog_masonry_ql_author_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_author_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_ql_author_lineheight",
	$blog_masonry_ql_author_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group6->addChild(
	"row2",
	$row2
);

$blog_masonry_ql_author_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_author_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_masonry_ql_author_texttransform",
	$blog_masonry_ql_author_texttransform
);

$blog_masonry_ql_author_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_ql_author_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_ql_author_google_fonts",
	$blog_masonry_ql_author_google_fonts
);

$blog_masonry_ql_author_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_author_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_ql_author_fontstyle",
	$blog_masonry_ql_author_fontstyle
);

$blog_masonry_ql_author_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_ql_author_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_ql_author_fontweight",
	$blog_masonry_ql_author_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group6->addChild(
	"row3",
	$row3
);

$blog_masonry_ql_author_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_ql_author_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_ql_author_letterspacing",
	$blog_masonry_ql_author_letterspacing
);

// Blog Post List - Blog: Standard
$panel21 = new HudsonEdgePanel(
	esc_html__( "Blog List Template Options: Standard", 'hudson' ),
	"blog_standard_type_post_lists",
	"blog_standard_type_show_options",
	"no"
);
$blogPage->addChild(
	"panel21",
	$panel21
);

$blog_standard_type_number_of_chars = new HudsonEdgeField(
	"text",
	"blog_standard_type_number_of_chars",
	"45",
	esc_html__( "Number of Words in Excerpt", 'hudson' ),
	' Enter a number of words in excerpt (article summary)',
	array(),
	array( "col_width" => 3 )
);
$panel21->addChild(
	"blog_standard_type_number_of_chars",
	$blog_standard_type_number_of_chars
);

$blog_standard_type_image_size = new HudsonEdgeField(
	"select",
	"blog_standard_type_image_size",
	"full",
	esc_html__( "Blog Image Size", 'hudson' ),
	esc_html__( "Choose image size for Post List", 'hudson' ),
	array(
		"full" => esc_html__( "Default", 'hudson' ),
		"portfolio-landscape" => esc_html__( "Landscape", 'hudson' ),
		"portfolio-portrait" => esc_html__( "Portrait", 'hudson' ),
		"custom" => esc_html__( "Custom", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"full"                => "#edgtf_blog_standard_type_image_size_container",
			"portfolio-landscape" => "#edgtf_blog_standard_type_image_size_container",
			"portfolio-portrait"  => "#edgtf_blog_standard_type_image_size_container",
			"custom"              => ""
		),
		"show"       => array(
			"full"                => "",
			"portfolio-landscape" => "",
			"portfolio-portrait"  => "",
			"custom"              => "#edgtf_blog_standard_type_image_size_container"
		)
	)
);
$panel21->addChild(
	"blog_standard_type_image_size",
	$blog_standard_type_image_size
);

$blog_standard_type_image_size_container = new HudsonEdgeContainer(
	"blog_standard_type_image_size_container",
	"blog_standard_type_image_size",
	"",
	array(
		"full",
		"portfolio-landscape",
		"portfolio-portrait"
	)
);
$panel21->addChild(
	"blog_standard_type_image_size_container",
	$blog_standard_type_image_size_container
);

$blog_standard_type_image_size_height = new HudsonEdgeField(
	"text",
	"blog_standard_type_image_size_height",
	"",
	esc_html__( "Image Height (px)", 'hudson' ),
	esc_html__( "Enter width (in pixels) for Custom Image for Post List", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_standard_type_image_size_container->addChild(
	"blog_standard_type_image_size_height",
	$blog_standard_type_image_size_height
);

$blog_standard_type_image_size_width = new HudsonEdgeField(
	"text",
	"blog_standard_type_image_size_width",
	"",
	esc_html__( "Image Width (px)", 'hudson' ),
	esc_html__( "Enter width (in pixels) for Custom Image for Post List", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_standard_type_image_size_container->addChild(
	"blog_standard_type_image_size_width",
	$blog_standard_type_image_size_width
);

$blog_standard_type_read_more_button = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_read_more_button",
	"no",
	esc_html__( "Read More Button", 'hudson' ),
	esc_html__( "Enable Read More Button", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_read_more_button_container"
	)
);
$panel21->addChild(
	"blog_standard_type_read_more_button",
	$blog_standard_type_read_more_button
);

$blog_standard_type_read_more_button_container = new HudsonEdgeContainer(
	"blog_standard_type_read_more_button_container",
	"blog_standard_type_read_more_button",
	"no"
);
$panel21->addChild(
	"blog_standard_type_read_more_button_container",
	$blog_standard_type_read_more_button_container
);

$blog_standard_type_read_more_button_icon = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_read_more_button_icon",
	"no",
	esc_html__( "Enable Icon", 'hudson' ),
	esc_html__( "Enabling this option will place icon in read more button", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_read_more_button_icon_container"
	)
);
$blog_standard_type_read_more_button_container->addChild(
	"blog_standard_type_read_more_button_icon",
	$blog_standard_type_read_more_button_icon
);

$blog_standard_type_read_more_button_icon_container = new HudsonEdgeContainer(
	"blog_standard_type_read_more_button_icon_container",
	"blog_standard_type_read_more_button_icon",
	"no"
);
$blog_standard_type_read_more_button_container->addChild(
	"blog_standard_type_read_more_button_icon_container",
	$blog_standard_type_read_more_button_icon_container
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$blog_standard_type_read_more_button_icon_pack_hide_array = array();
$blog_standard_type_read_more_button_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$blog_standard_type_read_more_button_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$blog_standard_type_read_more_button_icon_pack_hide_array[ $dep_collection_key ] = '';
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$blog_standard_type_read_more_button_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_blog_standard_type_read_more_button_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $blog_standard_type_read_more_button_icon_collections_params as $blog_standard_type_read_more_button_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $blog_standard_type_read_more_button_icon_collections_param !== $dep_collection_object->param ) {
				$blog_standard_type_read_more_button_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_blog_standard_type_read_more_button_icon_' . $blog_standard_type_read_more_button_icon_collections_param . '_container,';
			}
		}
		
		//remove remaining ',' character
		$blog_standard_type_read_more_button_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$blog_standard_type_read_more_button_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$blog_standard_type_read_more_button_icon_pack = new HudsonEdgeField(
	"select",
	"blog_standard_type_read_more_button_icon_pack",
	"font_awesome",
	esc_html__( "Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for show load more button", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		"dependence" => true,
		"hide"       => $blog_standard_type_read_more_button_icon_pack_hide_array,
		"show"       => $blog_standard_type_read_more_button_icon_pack_show_array
	)
);

$blog_standard_type_read_more_button_icon_container->addChild(
	"blog_standard_type_read_more_button_icon_pack",
	$blog_standard_type_read_more_button_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$blog_standard_type_read_more_button_icon_hide_values = $icon_collections_keys;
		$blog_icon_container                                  = new HudsonEdgeContainer(
			"blog_standard_type_read_more_button_icon_" . $collection_object->param . "_container",
			"blog_standard_type_read_more_button_icon_pack",
			"",
			$blog_standard_type_read_more_button_icon_hide_values
		);
		$blog_standard_type_read_more_button_icon             = new HudsonEdgeField(
			"select",
			"blog_standard_type_read_more_button_icon_" . $collection_object->param,
			"",
			esc_html__( "Button Icon", 'hudson' ),
			esc_html__( "Choose Button Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$blog_icon_container->addChild(
			"blog_standard_type_read_more_button_icon_" . $collection_object->param,
			$blog_standard_type_read_more_button_icon
		);
		
		$blog_standard_type_read_more_button_icon_container->addChild(
			"blog_standard_type_read_more_button_icon_" . $collection_object->param . "_container",
			$blog_icon_container
		);
	}
	
}

$blog_standard_type_content_position = new HudsonEdgeField(
	"select",
	"blog_standard_type_content_position",
	"content_above_blog_list",
	esc_html__( "Content Position", 'hudson' ),
	esc_html__( "Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", 'hudson' ),
	array(
		"content_above_blog_list" => esc_html__( "Content Above Blog List", 'hudson' ),
		"content_above_blog_list_and_sidebar" => esc_html__( "Content Above Blog List and Sidebar", 'hudson' )
	)
);
$panel21->addChild(
	"blog_standard_type_content_position",
	$blog_standard_type_content_position
);

$blog_standard_type_post_meta_data_section = new HudsonEdgeTitle(
	"blog_standard_type_post_meta_data_section",
	esc_html__( "Post Info Data Fields", 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_post_meta_data_section",
	$blog_standard_type_post_meta_data_section
);

$blog_standard_type_show_categories = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_categories",
	"yes",
	esc_html__( "Show Categories", 'hudson' ),
	esc_html__( "Enabling this option will Show Categories on Post List", 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_show_categories",
	$blog_standard_type_show_categories
);

$blog_standard_type_show_comments = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_comments",
	"yes",
	esc_html__( "Show Comments", 'hudson' ),
	esc_html__( "Enabling this option will Show Comments on Post List", 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_show_comments",
	$blog_standard_type_show_comments
);

$blog_standard_type_show_author = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_author",
	"yes",
	esc_html__( "Show Author Name", 'hudson' ),
	esc_html__( "Enabling this option will show author name on Post List and Blog Post Single", 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_show_author",
	$blog_standard_type_show_author
);

$blog_standard_type_show_date = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_date",
	"yes",
	esc_html__( "Show Date", 'hudson' ),
	esc_html__( "Enabling this option will show date on Post List", 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_hide_date",
	$blog_standard_type_show_date
);

$blog_standard_type_show_share = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_share",
	"yes",
	esc_html__( "Show Share", 'hudson' ),
	esc_html__( "Enabling this option will show share on Post List", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_share_options_container"
	)
);
$panel21->addChild(
	"blog_standard_type_show_share",
	$blog_standard_type_show_share
);

$blog_standard_type_share_options_container = new HudsonEdgeContainer(
	"blog_standard_type_share_options_container",
	"blog_standard_type_show_share",
	"no"
);
$panel21->addChild(
	"blog_standard_type_share_options_container",
	$blog_standard_type_share_options_container
);

$blog_standard_type_share_background_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_share_background_color",
	"",
	" Dropdown Background Color",
	esc_html__( "Choose background color for dropdown share type", 'hudson' )
);
$blog_standard_type_share_options_container->addChild(
	"blog_standard_type_share_background_color",
	$blog_standard_type_share_background_color
);

$blog_standard_type_share_icon_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_share_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for dropdown and list share type", 'hudson' )
);
$blog_standard_type_share_options_container->addChild(
	"blog_standard_type_share_icon_color",
	$blog_standard_type_share_icon_color
);

$blog_standard_type_share_icon_hover_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_share_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose icon hover color for dropdown and list Share Type", 'hudson' )
);
$blog_standard_type_share_options_container->addChild(
	"blog_standard_type_share_icon_hover_color",
	$blog_standard_type_share_icon_hover_color
);

$blog_standard_type_share_icon_color_link_post_type = new HudsonEdgeField(
	"color",
	"blog_standard_type_share_icon_color_link_post_type",
	"",
	esc_html__( "Icon Color For Quote/Link Post Type", 'hudson' ),
	esc_html__( "Choose icon color for dropdown and list share type for quote post type", 'hudson' )
);
$blog_standard_type_share_options_container->addChild(
	"blog_standard_type_share_icon_color_link_post_type",
	$blog_standard_type_share_icon_color_link_post_type
);

$blog_standard_type_share_icon_hover_color_link_post_type = new HudsonEdgeField(
	"color",
	"blog_standard_type_share_icon_hover_color_link_post_type",
	"",
	esc_html__( "Icon Hover Color For Quote/Link Post Type", 'hudson' ),
	esc_html__( "Choose icon hover color for dropdown and list Share Type for quote post type", 'hudson' )
);
$blog_standard_type_share_options_container->addChild(
	"blog_standard_type_share_icon_hover_color_link_post_type",
	$blog_standard_type_share_icon_hover_color_link_post_type
);

$blog_standard_type_show_like = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_like",
	"no",
	esc_html__( "Show Likes", 'hudson' ),
	esc_html__( 'Enabling this option will turn on "Likes"', 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_show_like",
	$blog_standard_type_show_like
);

$blog_standard_type_enable_pattern = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_enable_pattern",
	"yes",
	esc_html__( "Enable Pattern on Post Info", 'hudson' ),
	esc_html__( "Enable this option to show pattern on date, comments and share holders", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_pattern_container",
		"dependence_hide_on_yes" => ""
	)
);
$panel21->addChild(
	"blog_standard_type_enable_pattern",
	$blog_standard_type_enable_pattern
);

$blog_standard_type_pattern_container = new HudsonEdgeContainer(
	"blog_standard_type_pattern_container",
	"blog_standard_type_enable_pattern",
	"no"
);
$panel21->addChild(
	"blog_standard_type_pattern_container",
	$blog_standard_type_pattern_container
);

$blog_standard_type_info_pattern = new HudsonEdgeField(
	"image",
	"blog_standard_type_info_pattern",
	"",
	esc_html__( "Pattern", 'hudson' ),
	esc_html__( "Choose a pattern", 'hudson' )
);
$blog_standard_type_pattern_container->addChild(
	"blog_standard_type_info_pattern",
	$blog_standard_type_info_pattern
);

$blog_standard_type_post_design_style = new HudsonEdgeTitle(
	"blog_standard_type_post_design_style",
	esc_html__( "Post Design Style", 'hudson' )
);
$panel21->addChild(
	"blog_standard_type_post_design_style",
	$blog_standard_type_post_design_style
);

$blog_standard_type_enable_text_box = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_enable_text_box",
	"no",
	esc_html__( "Enable Boxed Styled Post Content", 'hudson' ),
	esc_html__( "Enable post text boxed features", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_enable_text_box_container"
	)
);
$panel21->addChild(
	"blog_standard_type_enable_text_box",
	$blog_standard_type_enable_text_box
);

$blog_standard_type_enable_text_box_container = new HudsonEdgeContainer(
	"blog_standard_type_enable_text_box_container",
	"blog_standard_type_enable_text_box",
	"no"
);
$panel21->addChild(
	"blog_standard_type_enable_text_box_container",
	$blog_standard_type_enable_text_box_container
);

$blog_standard_type_box_background_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_box_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for post text box", 'hudson' )
);
$blog_standard_type_enable_text_box_container->addChild(
	"blog_standard_type_box_background_color",
	$blog_standard_type_box_background_color
);

$blog_standard_type_box_border_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_box_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color for post text box", 'hudson' )
);
$blog_standard_type_enable_text_box_container->addChild(
	"blog_standard_type_box_border_color",
	$blog_standard_type_box_border_color
);

$blog_standard_type_box_padding = new HudsonEdgeField(
	"text",
	"blog_standard_type_box_padding",
	"",
	esc_html__( "Text box padding", 'hudson' ),
	esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_standard_type_enable_text_box_container->addChild(
	"blog_standard_type_box_padding",
	$blog_standard_type_box_padding
);

$group10 = new HudsonEdgeGroup(
	esc_html__( "Paragraph", 'hudson' ),
	esc_html__( "Set paragraph color", 'hudson' )
);
$panel21->addChild(
	"group10",
	$group10
);

$blog_standard_type_paragraph_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_paragraph_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$group10->addChild(
	"blog_standard_type_paragraph_color",
	$blog_standard_type_paragraph_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Background", 'hudson' ),
	esc_html__( "Set background of Quote/Link post type", 'hudson' )
);
$panel21->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$blog_standard_type_ql_background_image = new HudsonEdgeField(
	"yesnosimple",
	"blog_standard_type_ql_background_image",
	"yes",
	esc_html__( "Background Image", 'hudson' ),
	""
);
$row1->addChild(
	"blog_standard_type_ql_background_image",
	$blog_standard_type_ql_background_image
);

$blog_standard_type_ql_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Default color is #ffffff.", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_background_color",
	$blog_standard_type_ql_background_color
);

$blog_standard_type_ql_background_color_opacity = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_background_color_opacity",
	"",
	esc_html__( "Background Color Transparency (0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_background_color_opacity",
	$blog_standard_type_ql_background_color_opacity
);

$row2 = new HudsonEdgeRow();
$group1->addChild(
	"row2",
	$row2
);

$blog_standard_type_ql_hover_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_hover_background_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "Default color is #e6ae48.", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_ql_hover_background_color",
	$blog_standard_type_ql_hover_background_color
);

$blog_standard_type_ql_hover_background_color_opacity = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_hover_background_color_opacity",
	"",
	esc_html__( "Background Color Hover Transparency (0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_ql_hover_background_color_opacity",
	$blog_standard_type_ql_hover_background_color_opacity
);

$blog_standard_type_show_ql_mark = new HudsonEdgeField(
	"yesno",
	"blog_standard_type_show_ql_mark",
	"yes",
	esc_html__( "Enable Quote/Link Icon", 'hudson' ),
	esc_html__( "Show Icons for Quote/Link Post Format", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_standard_type_show_ql_mark_container"
	)
);
$panel21->addChild(
	"blog_standard_type_show_ql_mark",
	$blog_standard_type_show_ql_mark
);

$blog_standard_type_show_ql_mark_container = new HudsonEdgeContainer(
	"blog_standard_type_show_ql_mark_container",
	"blog_standard_type_show_ql_mark",
	"no"
);
$panel21->addChild(
	"blog_standard_type_show_ql_mark_container",
	$blog_standard_type_show_ql_mark_container
);

$row1 = new HudsonEdgeRow();
$blog_standard_type_show_ql_mark_container->addChild(
	"row1",
	$row1
);

$blog_standard_type_ql_mark_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_ql_mark_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for quote/link post.", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_mark_color",
	$blog_standard_type_ql_mark_color
);

$blog_standard_type_ql_mark_hover_color = new HudsonEdgeField(
	"color",
	"blog_standard_type_ql_mark_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose hover icon color for quote/link post.", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_mark_hover_color",
	$blog_standard_type_ql_mark_hover_color
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Separators Style", 'hudson' ),
	esc_html__( "Define style for separators in blog", 'hudson' )
);
$panel21->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);

$blog_standard_type_separators_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_separators_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_separators_color",
	$blog_standard_type_separators_color
);

$group11 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel21->addChild(
	"group11",
	$group11
);

$row1 = new HudsonEdgeRow();
$group11->addChild(
	"row1",
	$row1
);

$blog_standard_type_image_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_image_margin_bottom",
	"",
	esc_html__( "Margin Under Image (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_image_margin_bottom",
	$blog_standard_type_image_margin_bottom
);

$blog_standard_type_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_title_margin_bottom",
	$blog_standard_type_title_margin_bottom
);

$blog_standard_type_read_more_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_read_more_margin_top",
	"",
	esc_html__( "Margin Above Read More Button (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_read_more_margin_top",
	$blog_standard_type_read_more_margin_top
);

$blog_standard_type_post_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_post_info_margin_bottom",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_post_info_margin_bottom",
	$blog_standard_type_post_info_margin_bottom
);

$row2 = new HudsonEdgeRow();
$group11->addChild(
	"row2",
	$row2
);

$blog_standard_type_article_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_article_margin_bottom",
	"",
	esc_html__( "Margin Between Articles (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_article_margin_bottom",
	$blog_standard_type_article_margin_bottom
);

$blog_standard_type_single_article_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_single_article_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Comments and Social Share List Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_single_article_social_share_list_margin_top",
	$blog_standard_type_single_article_social_share_list_margin_top
);

$group12 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing for Quote and Link Post Type", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel21->addChild(
	"group12",
	$group12
);

$row1 = new HudsonEdgeRow();
$group12->addChild(
	"row1",
	$row1
);

$blog_standard_type_ql_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_title_margin_bottom",
	$blog_standard_type_ql_title_margin_bottom
);

$blog_standard_type_ql_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Comments and Social Share List Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_social_share_list_margin_top",
	$blog_standard_type_ql_social_share_list_margin_top
);

$blog_standard_type_ql_quote_author_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_quote_author_margin_bottom",
	"",
	esc_html__( "Margin Under Quote Author (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_quote_author_margin_bottom",
	$blog_standard_type_ql_quote_author_margin_bottom
);

$post_text_styling = new HudsonEdgeTitle(
	"post_text_styling",
	esc_html__( "Post Text Style", 'hudson' )
);
$panel21->addChild(
	"post_text_styling",
	$post_text_styling
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Post Title", 'hudson' ),
	esc_html__( "Define title styles in this blog post template.", 'hudson' )
);
$panel21->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);

$blog_standard_type_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_title_color",
	$blog_standard_type_title_color
);

$blog_standard_type_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_title_hover_color",
	$blog_standard_type_title_hover_color
);

$blog_standard_type_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_title_fontsize",
	$blog_standard_type_title_fontsize
);

$blog_standard_type_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_title_lineheight",
	$blog_standard_type_title_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group5->addChild(
	"row2",
	$row2
);

$blog_standard_type_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_standard_type_title_texttransform",
	$blog_standard_type_title_texttransform
);

$blog_standard_type_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_standard_type_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_title_google_fonts",
	$blog_standard_type_title_google_fonts
);

$blog_standard_type_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_standard_type_title_fontstyle",
	$blog_standard_type_title_fontstyle
);

$blog_standard_type_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_standard_type_title_fontweight",
	$blog_standard_type_title_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group5->addChild(
	"row3",
	$row3
);

$blog_standard_type_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_standard_type_title_letterspacing",
	$blog_standard_type_title_letterspacing
);

$group7 = new HudsonEdgeGroup(
	esc_html__( "Post Info Data", 'hudson' ),
	esc_html__( "Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list", 'hudson' )
);
$panel21->addChild(
	"group7",
	$group7
);

$row1 = new HudsonEdgeRow();
$group7->addChild(
	"row1",
	$row1
);

$blog_standard_type_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_info_color",
	$blog_standard_type_info_color
);

$blog_standard_type_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_info_link_color",
	$blog_standard_type_info_link_color
);

$blog_standard_type_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_info_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_info_hover_color",
	$blog_standard_type_info_hover_color
);

$blog_standard_type_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_info_fontsize",
	$blog_standard_type_info_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group7->addChild(
	"row2",
	$row2
);

$blog_standard_type_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_info_lineheight",
	$blog_standard_type_info_lineheight
);

$blog_standard_type_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_standard_type_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_info_google_fonts",
	$blog_standard_type_info_google_fonts
);

$blog_standard_type_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_standard_type_info_fontstyle",
	$blog_standard_type_info_fontstyle
);

$blog_standard_type_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_standard_type_info_fontweight",
	$blog_standard_type_info_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group7->addChild(
	"row3",
	$row3
);

$blog_standard_type_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_standard_type_info_texttransform",
	$blog_standard_type_info_texttransform
);

$blog_standard_type_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_standard_type_info_letterspacing",
	$blog_standard_type_info_letterspacing
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Title Style", 'hudson' ),
	esc_html__( "Define title styles for Quote/Link articles", 'hudson' )
);
$panel21->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$blog_standard_type_ql_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_title_color",
	$blog_standard_type_ql_title_color
);

$blog_standard_type_ql_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_title_hover_color",
	$blog_standard_type_ql_title_hover_color
);

$blog_standard_type_ql_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_title_font_size",
	$blog_standard_type_ql_title_fontsize
);

$blog_standard_type_ql_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_title_lineheight",
	$blog_standard_type_ql_title_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group6->addChild(
	"row2",
	$row2
);

$blog_standard_type_ql_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_standard_type_ql_title_texttransform",
	$blog_standard_type_ql_title_texttransform
);

$blog_standard_type_ql_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_standard_type_ql_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_ql_title_google_fonts",
	$blog_standard_type_ql_title_google_fonts
);

$blog_standard_type_ql_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_standard_type_ql_title_fontstyle",
	$blog_standard_type_ql_title_fontstyle
);

$blog_standard_type_ql_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_standard_type_ql_title_fontweight",
	$blog_standard_type_ql_title_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group6->addChild(
	"row3",
	$row3
);

$blog_standard_type_ql_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_standard_type_ql_title_letterspacing",
	$blog_standard_type_ql_title_letterspacing
);

$group8 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Post Info Data", 'hudson' ),
	esc_html__( "Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.", 'hudson' )
);
$panel21->addChild(
	"group8",
	$group8
);

$row1 = new HudsonEdgeRow();
$group8->addChild(
	"row1",
	$row1
);

$blog_standard_type_ql_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_info_color",
	$blog_standard_type_ql_info_color
);

$blog_standard_type_ql_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_info_link_color",
	$blog_standard_type_ql_info_link_color
);

$blog_standard_type_ql_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_info_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_info_hover_color",
	$blog_standard_type_ql_info_hover_color
);

$blog_standard_type_ql_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_info_fontsize",
	$blog_standard_type_ql_info_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group8->addChild(
	"row2",
	$row2
);

$blog_standard_type_ql_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_ql_info_lineheight",
	$blog_standard_type_ql_info_lineheight
);

$blog_standard_type_ql_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_standard_type_ql_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_ql_info_google_fonts",
	$blog_standard_type_ql_info_google_fonts
);

$blog_standard_type_ql_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_standard_type_ql_info_fontstyle",
	$blog_standard_type_ql_info_fontstyle
);

$blog_standard_type_ql_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_standard_type_ql_info_fontweight",
	$blog_standard_type_ql_info_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group8->addChild(
	"row3",
	$row3
);

$blog_standard_type_ql_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_standard_type_ql_info_texttransform",
	$blog_standard_type_ql_info_texttransform
);

$blog_standard_type_ql_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_standard_type_ql_info_letterspacing",
	$blog_standard_type_ql_info_letterspacing
);

$group9 = new HudsonEdgeGroup(
	esc_html__( "Quote Author Style", 'hudson' ),
	esc_html__( "Define author styles for Quote articles", 'hudson' )
);
$panel21->addChild(
	"group9",
	$group9
);

$row1 = new HudsonEdgeRow();
$group9->addChild(
	"row1",
	$row1
);

$blog_standard_type_ql_author_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_author_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_author_color",
	$blog_standard_type_ql_author_color
);

$blog_standard_type_ql_author_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_standard_type_ql_author_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_author_hover_color",
	$blog_standard_type_ql_author_hover_color
);

$blog_standard_type_ql_author_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_author_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_author_font_size",
	$blog_standard_type_ql_author_fontsize
);

$blog_standard_type_ql_author_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_author_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_standard_type_ql_author_lineheight",
	$blog_standard_type_ql_author_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group9->addChild(
	"row2",
	$row2
);

$blog_standard_type_ql_author_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_author_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_standard_type_ql_author_texttransform",
	$blog_standard_type_ql_author_texttransform
);

$blog_standard_type_ql_author_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_standard_type_ql_author_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_standard_type_ql_author_google_fonts",
	$blog_standard_type_ql_author_google_fonts
);

$blog_standard_type_ql_author_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_author_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_standard_type_ql_author_fontstyle",
	$blog_standard_type_ql_author_fontstyle
);

$blog_standard_type_ql_author_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_standard_type_ql_author_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_standard_type_ql_author_fontweight",
	$blog_standard_type_ql_author_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group9->addChild(
	"row3",
	$row3
);

$blog_standard_type_ql_author_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_standard_type_ql_author_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_standard_type_ql_author_letterspacing",
	$blog_standard_type_ql_author_letterspacing
);

// Blog Post List - Blog: Vertical Loop
$panel22 = new HudsonEdgePanel(
	esc_html__( "Blog List Template Options: Vertical Loop", 'hudson' ),
	"blog_vertical_loop_post_lists",
	"blog_vertical_loop_show_options",
	"no"
);
$blogPage->addChild(
	"panel22",
	$panel22
);

$blog_vertical_loop_type_number_of_chars = new HudsonEdgeField(
	"text",
	"blog_vertical_loop_type_number_of_chars",
	"45",
	esc_html__( "Number of Words in Excerpt", 'hudson' ),
	' Enter a number of words in excerpt (article summary)',
	array(),
	array( "col_width" => 3 )
);
$panel22->addChild(
	"blog_vertical_loop_type_number_of_chars",
	$blog_vertical_loop_type_number_of_chars
);

$blog_vertical_loop_type_post_meta_data_section = new HudsonEdgeTitle(
	"blog_vertical_loop_type_post_meta_data_section",
	esc_html__( "Post Info Data Fields", 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_post_meta_data_section",
	$blog_vertical_loop_type_post_meta_data_section
);

$blog_vertical_loop_type_show_categories = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_categories",
	"yes",
	esc_html__( "Show Categories", 'hudson' ),
	esc_html__( "Enabling this option will Show Categories on Post List", 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_show_categories",
	$blog_vertical_loop_type_show_categories
);

$blog_vertical_loop_type_show_comments = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_comments",
	"no",
	esc_html__( "Show Comments", 'hudson' ),
	esc_html__( "Enabling this option will Show Comments on Post List", 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_show_comments",
	$blog_vertical_loop_type_show_comments
);

$blog_vertical_loop_type_show_author = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_author",
	"yes",
	esc_html__( "Show Author Name", 'hudson' ),
	esc_html__( "Enabling this option will show author name on Post List and Blog Post Single", 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_show_author",
	$blog_vertical_loop_type_show_author
);

$blog_vertical_loop_type_show_date = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_date",
	"yes",
	esc_html__( "Show Date", 'hudson' ),
	esc_html__( "Enabling this option will show date on Post List", 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_hide_date",
	$blog_vertical_loop_type_show_date
);

$blog_vertical_loop_type_show_share = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_share",
	"no",
	esc_html__( "Show Share", 'hudson' ),
	esc_html__( "Enabling this option will show share on Post List", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_vertical_loop_type_share_options_container"
	)
);
$panel22->addChild(
	"blog_vertical_loop_type_show_share",
	$blog_vertical_loop_type_show_share
);

$blog_vertical_loop_type_share_options_container = new HudsonEdgeContainer(
	"blog_vertical_loop_type_share_options_container",
	"blog_vertical_loop_type_show_share",
	"no"
);
$panel22->addChild(
	"blog_vertical_loop_type_share_options_container",
	$blog_vertical_loop_type_share_options_container
);

$blog_vertical_loop_type_select_share_option = new HudsonEdgeField(
	"select",
	"blog_vertical_loop_type_select_share_option",
	"dropdown",
	esc_html__( "Social Share Style", 'hudson' ),
	esc_html__( "Choose Social Share Style for Standard Type", 'hudson' ),
	array(
		"dropdown" => esc_html__( "Social Share Dropdown", 'hudson' ),
		"list" => esc_html__( "Social Share List", 'hudson' )
	)
);

$blog_vertical_loop_type_share_options_container->addChild(
	"blog_vertical_loop_type_select_share_option",
	$blog_vertical_loop_type_select_share_option
);

$blog_vertical_loop_type_share_icon_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_share_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for dropdown and list share type", 'hudson' )
);
$blog_vertical_loop_type_share_options_container->addChild(
	"blog_vertical_loop_type_share_icon_color",
	$blog_vertical_loop_type_share_icon_color
);

$blog_vertical_loop_type_share_icon_hover_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_share_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose icon hover color for dropdown and list Share Type", 'hudson' )
);
$blog_vertical_loop_type_share_options_container->addChild(
	"blog_vertical_loop_type_share_icon_hover_color",
	$blog_vertical_loop_type_share_icon_hover_color
);

$blog_vertical_loop_type_share_background_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_share_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for dropdown share type", 'hudson' )
);
$blog_vertical_loop_type_share_options_container->addChild(
	"blog_vertical_loop_type_share_background_color",
	$blog_vertical_loop_type_share_background_color
);

$blog_vertical_loop_type_show_like = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_like",
	"no",
	esc_html__( "Show Likes", 'hudson' ),
	esc_html__( 'Enabling this option will turn on "Likes"', 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_show_like",
	$blog_vertical_loop_type_show_like
);

$blog_vertical_loop_type_post_design_style = new HudsonEdgeTitle(
	"blog_vertical_loop_type_post_design_style",
	esc_html__( "Post Design Style", 'hudson' )
);
$panel22->addChild(
	"blog_vertical_loop_type_post_design_style",
	$blog_vertical_loop_type_post_design_style
);

$blog_vertical_loop_type_enable_text_box = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_enable_text_box",
	"no",
	esc_html__( "Enable Boxed Styled Post Content", 'hudson' ),
	esc_html__( "Enable post text boxed features", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_vertical_loop_type_enable_text_box_container"
	)
);
$panel22->addChild(
	"blog_vertical_loop_type_enable_text_box",
	$blog_vertical_loop_type_enable_text_box
);

$blog_vertical_loop_type_enable_text_box_container = new HudsonEdgeContainer(
	"blog_vertical_loop_type_enable_text_box_container",
	"blog_vertical_loop_type_enable_text_box",
	"no"
);
$panel22->addChild(
	"blog_vertical_loop_type_enable_text_box_container",
	$blog_vertical_loop_type_enable_text_box_container
);

$blog_vertical_loop_type_box_background_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_box_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for post text box", 'hudson' )
);
$blog_vertical_loop_type_enable_text_box_container->addChild(
	"blog_vertical_loop_type_box_background_color",
	$blog_vertical_loop_type_box_background_color
);

$blog_vertical_loop_type_box_border_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_box_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color for post text box", 'hudson' )
);
$blog_vertical_loop_type_enable_text_box_container->addChild(
	"blog_vertical_loop_type_box_border_color",
	$blog_vertical_loop_type_box_border_color
);

$blog_vertical_loop_type_box_padding = new HudsonEdgeField(
	"text",
	"blog_vertical_loop_type_box_padding",
	"",
	esc_html__( "Text box padding", 'hudson' ),
	esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_vertical_loop_type_enable_text_box_container->addChild(
	"blog_vertical_loop_type_box_padding",
	$blog_vertical_loop_type_box_padding
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Background", 'hudson' ),
	esc_html__( "Set background of Quote/Link post type", 'hudson' )
);
$panel22->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_ql_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Default color is #ffffff.", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_background_color",
	$blog_vertical_loop_type_ql_background_color
);

$blog_vertical_loop_type_ql_hover_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_hover_background_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "Default color is #e6ae48.", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_hover_background_color",
	$blog_vertical_loop_type_ql_hover_background_color
);

$blog_vertical_loop_type_show_ql_mark = new HudsonEdgeField(
	"yesno",
	"blog_vertical_loop_type_show_ql_mark",
	"yes",
	esc_html__( "Enable Quote/Link Icon", 'hudson' ),
	esc_html__( "Show Icons for Quote/Link Post Format", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_vertical_loop_type_show_ql_mark_container"
	)
);
$panel22->addChild(
	"blog_vertical_loop_type_show_ql_mark",
	$blog_vertical_loop_type_show_ql_mark
);

$blog_vertical_loop_type_show_ql_mark_container = new HudsonEdgeContainer(
	"blog_vertical_loop_type_show_ql_mark_container",
	"blog_vertical_loop_type_show_ql_mark",
	"no"
);
$panel22->addChild(
	"blog_vertical_loop_type_show_ql_mark_container",
	$blog_vertical_loop_type_show_ql_mark_container
);

$row1 = new HudsonEdgeRow();
$blog_vertical_loop_type_show_ql_mark_container->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_ql_mark_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_ql_mark_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for quote/link post.", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_mark_color",
	$blog_vertical_loop_type_ql_mark_color
);

$blog_vertical_loop_type_ql_mark_hover_color = new HudsonEdgeField(
	"color",
	"blog_vertical_loop_type_ql_mark_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose hover icon color for quote/link post.", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_mark_hover_color",
	$blog_vertical_loop_type_ql_mark_hover_color
);

$blog_vertical_loop_type_image_height = new HudsonEdgeField(
	"text",
	"blog_vertical_loop_type_image_height",
	"",
	esc_html__( "Image Height", 'hudson' ),
	esc_html__( "Define image height for current and next article", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel22->addChild(
	"blog_vertical_loop_type_image_height",
	$blog_vertical_loop_type_image_height
);

$group11 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel22->addChild(
	"group11",
	$group11
);

$row1 = new HudsonEdgeRow();
$group11->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_image_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_image_margin_bottom",
	"",
	esc_html__( "Margin Under Image (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_image_margin_bottom",
	$blog_vertical_loop_type_image_margin_bottom
);

$blog_vertical_loop_type_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_title_margin_bottom",
	$blog_vertical_loop_type_title_margin_bottom
);

$blog_vertical_loop_type_post_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_post_info_margin_bottom",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_post_info_margin_bottom",
	$blog_vertical_loop_type_post_info_margin_bottom
);

$blog_vertical_loop_type_article_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_article_margin_bottom",
	"",
	esc_html__( "Margin Between Articles (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_article_margin_bottom",
	$blog_vertical_loop_type_article_margin_bottom
);

$row2 = new HudsonEdgeRow();
$group11->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_single_article_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_single_article_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Social Share List Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_single_article_social_share_list_margin_top",
	$blog_vertical_loop_type_single_article_social_share_list_margin_top
);

$group12 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing for Quote and Link Post Type", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel22->addChild(
	"group12",
	$group12
);

$row1 = new HudsonEdgeRow();
$group12->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_ql_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_title_margin_bottom",
	$blog_vertical_loop_type_ql_title_margin_bottom
);

$blog_vertical_loop_type_ql_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Social Share List (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_social_share_list_margin_top",
	$blog_vertical_loop_type_ql_social_share_list_margin_top
);

$blog_vertical_loop_type_ql_quote_author_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_quote_author_margin_bottom",
	"",
	esc_html__( "Margin Under Quote Author (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_quote_author_margin_bottom",
	$blog_vertical_loop_type_ql_quote_author_margin_bottom
);

$post_text_styling = new HudsonEdgeTitle(
	"post_text_styling",
	esc_html__( "Post Text Style", 'hudson' )
);
$panel22->addChild(
	"post_text_styling",
	$post_text_styling
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Post Title", 'hudson' ),
	esc_html__( "Define title styles in this blog post template.", 'hudson' )
);
$panel22->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_title_color",
	$blog_vertical_loop_type_title_color
);

$blog_vertical_loop_type_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_title_hover_color",
	$blog_vertical_loop_type_title_hover_color
);

$blog_vertical_loop_type_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_title_fontsize",
	$blog_vertical_loop_type_title_fontsize
);

$blog_vertical_loop_type_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_title_lineheight",
	$blog_vertical_loop_type_title_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group5->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_vertical_loop_type_title_texttransform",
	$blog_vertical_loop_type_title_texttransform
);

$blog_vertical_loop_type_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_vertical_loop_type_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_title_google_fonts",
	$blog_vertical_loop_type_title_google_fonts
);

$blog_vertical_loop_type_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_vertical_loop_type_title_fontstyle",
	$blog_vertical_loop_type_title_fontstyle
);

$blog_vertical_loop_type_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_title_fontweight",
	$blog_vertical_loop_type_title_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group5->addChild(
	"row3",
	$row3
);

$blog_vertical_loop_type_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_vertical_loop_type_title_letterspacing",
	$blog_vertical_loop_type_title_letterspacing
);

$group7 = new HudsonEdgeGroup(
	esc_html__( "Post Info Data", 'hudson' ),
	esc_html__( "Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list", 'hudson' )
);
$panel22->addChild(
	"group7",
	$group7
);

$row1 = new HudsonEdgeRow();
$group7->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_info_color",
	$blog_vertical_loop_type_info_color
);

$blog_vertical_loop_type_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_info_link_color",
	$blog_vertical_loop_type_info_link_color
);

$blog_vertical_loop_type_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_info_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_info_hover_color",
	$blog_vertical_loop_type_info_hover_color
);

$blog_vertical_loop_type_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_info_fontsize",
	$blog_vertical_loop_type_info_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group7->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_info_lineheight",
	$blog_vertical_loop_type_info_lineheight
);

$blog_vertical_loop_type_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_vertical_loop_type_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_info_google_fonts",
	$blog_vertical_loop_type_info_google_fonts
);

$blog_vertical_loop_type_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_vertical_loop_type_info_fontstyle",
	$blog_vertical_loop_type_info_fontstyle
);

$blog_vertical_loop_type_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_info_fontweight",
	$blog_vertical_loop_type_info_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group7->addChild(
	"row3",
	$row3
);

$blog_vertical_loop_type_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_vertical_loop_type_info_texttransform",
	$blog_vertical_loop_type_info_texttransform
);

$blog_vertical_loop_type_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_vertical_loop_type_info_letterspacing",
	$blog_vertical_loop_type_info_letterspacing
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Title Style", 'hudson' ),
	esc_html__( "Define title styles for Quote/Link articles", 'hudson' )
);
$panel22->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_ql_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_title_color",
	$blog_vertical_loop_type_ql_title_color
);

$blog_vertical_loop_type_ql_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_title_hover_color",
	$blog_vertical_loop_type_ql_title_hover_color
);

$blog_vertical_loop_type_ql_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_title_font_size",
	$blog_vertical_loop_type_ql_title_fontsize
);

$blog_vertical_loop_type_ql_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_title_lineheight",
	$blog_vertical_loop_type_ql_title_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group6->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_ql_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_title_texttransform",
	$blog_vertical_loop_type_ql_title_texttransform
);

$blog_vertical_loop_type_ql_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_vertical_loop_type_ql_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_ql_title_google_fonts",
	$blog_vertical_loop_type_ql_title_google_fonts
);

$blog_vertical_loop_type_ql_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_title_fontstyle",
	$blog_vertical_loop_type_ql_title_fontstyle
);

$blog_vertical_loop_type_ql_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_title_fontweight",
	$blog_vertical_loop_type_ql_title_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group6->addChild(
	"row3",
	$row3
);

$blog_vertical_loop_type_ql_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_vertical_loop_type_ql_title_letterspacing",
	$blog_vertical_loop_type_ql_title_letterspacing
);

$group8 = new HudsonEdgeGroup(
	esc_html__( "Quote/Link Post Info Data", 'hudson' ),
	esc_html__( "Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.", 'hudson' )
);
$panel22->addChild(
	"group8",
	$group8
);

$row1 = new HudsonEdgeRow();
$group8->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_ql_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_info_color",
	$blog_vertical_loop_type_ql_info_color
);

$blog_vertical_loop_type_ql_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_info_link_color",
	$blog_vertical_loop_type_ql_info_link_color
);

$blog_vertical_loop_type_ql_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_info_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_info_hover_color",
	$blog_vertical_loop_type_ql_info_hover_color
);

$blog_vertical_loop_type_ql_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_info_fontsize",
	$blog_vertical_loop_type_ql_info_fontsize
);

$row2 = new HudsonEdgeRow( true );
$group8->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_ql_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_ql_info_lineheight",
	$blog_vertical_loop_type_ql_info_lineheight
);

$blog_vertical_loop_type_ql_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_vertical_loop_type_ql_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_ql_info_google_fonts",
	$blog_vertical_loop_type_ql_info_google_fonts
);

$blog_vertical_loop_type_ql_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_info_fontstyle",
	$blog_vertical_loop_type_ql_info_fontstyle
);

$blog_vertical_loop_type_ql_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_info_fontweight",
	$blog_vertical_loop_type_ql_info_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group8->addChild(
	"row3",
	$row3
);

$blog_vertical_loop_type_ql_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_vertical_loop_type_ql_info_texttransform",
	$blog_vertical_loop_type_ql_info_texttransform
);

$blog_vertical_loop_type_ql_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_vertical_loop_type_ql_info_letterspacing",
	$blog_vertical_loop_type_ql_info_letterspacing
);

$group9 = new HudsonEdgeGroup(
	esc_html__( "Quote Author Style", 'hudson' ),
	esc_html__( "Define author styles for Quote articles", 'hudson' )
);
$panel22->addChild(
	"group9",
	$group9
);

$row1 = new HudsonEdgeRow();
$group9->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_ql_author_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_author_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_author_color",
	$blog_vertical_loop_type_ql_author_color
);

$blog_vertical_loop_type_ql_author_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_ql_author_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_author_hover_color",
	$blog_vertical_loop_type_ql_author_hover_color
);

$blog_vertical_loop_type_ql_author_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_author_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_author_font_size",
	$blog_vertical_loop_type_ql_author_fontsize
);

$blog_vertical_loop_type_ql_author_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_author_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_ql_author_lineheight",
	$blog_vertical_loop_type_ql_author_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group9->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_ql_author_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_author_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_author_texttransform",
	$blog_vertical_loop_type_ql_author_texttransform
);

$blog_vertical_loop_type_ql_author_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_vertical_loop_type_ql_author_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_ql_author_google_fonts",
	$blog_vertical_loop_type_ql_author_google_fonts
);

$blog_vertical_loop_type_ql_author_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_author_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_author_fontstyle",
	$blog_vertical_loop_type_ql_author_fontstyle
);

$blog_vertical_loop_type_ql_author_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_ql_author_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_ql_author_fontweight",
	$blog_vertical_loop_type_ql_author_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group9->addChild(
	"row3",
	$row3
);

$blog_vertical_loop_type_ql_author_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_ql_author_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_vertical_loop_type_ql_author_letterspacing",
	$blog_vertical_loop_type_ql_author_letterspacing
);

$post_vertical_loop_type_next_article_title = new HudsonEdgeTitle(
	"post_vertical_loop_type_next_article_title",
	esc_html__( "Next Article Styles", 'hudson' )
);
$panel22->addChild(
	"post_vertical_loop_type_next_article_title",
	$post_vertical_loop_type_next_article_title
);

$group10 = new HudsonEdgeGroup(
	esc_html__( "Title Style", 'hudson' ),
	esc_html__( "Define title styles for next article", 'hudson' )
);
$panel22->addChild(
	"group10",
	$group10
);

$row1 = new HudsonEdgeRow();
$group10->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_next_article_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_next_article_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_title_color",
	$blog_vertical_loop_type_next_article_title_color
);

$blog_vertical_loop_type_next_article_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_next_article_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_title_fontsize",
	$blog_vertical_loop_type_next_article_title_fontsize
);

$blog_vertical_loop_type_next_article_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_next_article_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_title_lineheight",
	$blog_vertical_loop_type_next_article_title_lineheight
);

$blog_vertical_loop_type_next_article_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_next_article_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_title_texttransform",
	$blog_vertical_loop_type_next_article_title_texttransform
);

$row2 = new HudsonEdgeRow( true );
$group10->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_next_article_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_vertical_loop_type_next_article_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_next_article_title_google_fonts",
	$blog_vertical_loop_type_next_article_title_google_fonts
);

$blog_vertical_loop_type_next_article_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_next_article_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_vertical_loop_type_next_article_title_fontstyle",
	$blog_vertical_loop_type_next_article_title_fontstyle
);

$blog_vertical_loop_type_next_article_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_next_article_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_next_article_title_fontweight",
	$blog_vertical_loop_type_next_article_title_fontweight
);

$blog_vertical_loop_type_next_article_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_next_article_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_next_article_title_letterspacing",
	$blog_vertical_loop_type_next_article_title_letterspacing
);

$row3 = new HudsonEdgeRow( true );
$group10->addChild(
	"row3",
	$row3
);

$blog_vertical_loop_type_next_article_title_position = new HudsonEdgeField(
	"selectsimple",
	"blog_vertical_loop_type_next_article_title_position",
	"dropdown",
	esc_html__( "Title Position", 'hudson' ),
	esc_html__( "Choose title position for next article", 'hudson' ),
	array(
		"center" => esc_html__( "Center", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);

$row3->addChild(
	"blog_vertical_loop_type_next_article_title_position",
	$blog_vertical_loop_type_next_article_title_position
);

$post_vertical_loop_type_next_previous_arrow_title = new HudsonEdgeTitle(
	"post_vertical_loop_type_next_previous_arrow_title",
	esc_html__( "Previous/Next Article Arrow Style", 'hudson' )
);
$panel22->addChild(
	"post_vertical_loop_type_next_previous_arrow_title",
	$post_vertical_loop_type_next_previous_arrow_title
);

$group13 = new HudsonEdgeGroup(
	esc_html__( "Article Arrow Style", 'hudson' ),
	esc_html__( "Define arrow styles for next article", 'hudson' )
);
$panel22->addChild(
	"group13",
	$group13
);

$row1 = new HudsonEdgeRow();
$group13->addChild(
	"row1",
	$row1
);

$blog_vertical_loop_type_next_article_arrow_background_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_next_article_arrow_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_arrow_background_color",
	$blog_vertical_loop_type_next_article_arrow_background_color
);

$blog_vertical_loop_type_next_article_arrow_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_next_article_arrow_color",
	"",
	esc_html__( "Arrow Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_arrow_color",
	$blog_vertical_loop_type_next_article_arrow_color
);

$blog_vertical_loop_type_next_article_arrow_background_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_next_article_arrow_background_hover_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_arrow_background_hover_color",
	$blog_vertical_loop_type_next_article_arrow_background_hover_color
);

$blog_vertical_loop_type_next_article_arrow_color_hover = new HudsonEdgeField(
	"colorsimple",
	"blog_vertical_loop_type_next_article_arrow_color_hover",
	"",
	esc_html__( "Arrow Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_vertical_loop_type_next_article_arrow_color_hover",
	$blog_vertical_loop_type_next_article_arrow_color_hover
);

$row2 = new HudsonEdgeRow();
$group13->addChild(
	"row2",
	$row2
);

$blog_vertical_loop_type_next_article_arrow_size = new HudsonEdgeField(
	"textsimple",
	"blog_vertical_loop_type_next_article_arrow_size",
	"",
	esc_html__( "Arrow Size", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_vertical_loop_type_next_article_arrow_size",
	$blog_vertical_loop_type_next_article_arrow_size
);

$blog_vertical_loop_type_next_article_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_vertical_loop_type_next_article_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_vertical_loop_type_next_article_font_weight",
	$blog_vertical_loop_type_next_article_font_weight
);

// Blog Post List - Blog: Masonry Gallery
$panel23 = new HudsonEdgePanel(
	esc_html__( "Blog List Templates Options: Masonry Gallery & Masonry Gallery Full Width", 'hudson' ),
	"blog_masonry_gallery_post_lists",
	"blog_masonry_gallery_show_options",
	"no"
);
$blogPage->addChild(
	"panel23",
	$panel23
);

$blog_masonry_gallery_number_of_chars = new HudsonEdgeField(
	"text",
	"blog_masonry_gallery_number_of_chars",
	"45",
	esc_html__( "Number of Words in Excerpt", 'hudson' ),
	' Enter a number of words in excerpt (article summary)',
	array(),
	array( "col_width" => 3 )
);
$panel23->addChild(
	"blog_masonry_gallery_number_of_chars",
	$blog_masonry_gallery_number_of_chars
);

$blog_masonry_gallery_read_more_button = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_read_more_button",
	"no",
	esc_html__( "Read More Button", 'hudson' ),
	esc_html__( "Enable Read More Button", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_gallery_read_more_button_container"
	)
);
$panel23->addChild(
	"blog_masonry_gallery_read_more_button",
	$blog_masonry_gallery_read_more_button
);

$blog_masonry_gallery_read_more_button_container = new HudsonEdgeContainer(
	"blog_masonry_gallery_read_more_button_container",
	"blog_masonry_gallery_read_more_button",
	"no"
);
$panel23->addChild(
	"blog_masonry_gallery_read_more_button_container",
	$blog_masonry_gallery_read_more_button_container
);

$blog_masonry_gallery_read_more_button_icon = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_read_more_button_icon",
	"no",
	esc_html__( "Enable Icon", 'hudson' ),
	esc_html__( "Enabling this option will place icon in read more button", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_gallery_read_more_button_icon_container"
	)
);
$blog_masonry_gallery_read_more_button_container->addChild(
	"blog_masonry_gallery_read_more_button_icon",
	$blog_masonry_gallery_read_more_button_icon
);

$blog_masonry_gallery_read_more_button_icon_container = new HudsonEdgeContainer(
	"blog_masonry_gallery_read_more_button_icon_container",
	"blog_masonry_gallery_read_more_button_icon",
	"no"
);
$blog_masonry_gallery_read_more_button_container->addChild(
	"blog_masonry_gallery_read_more_button_icon_container",
	$blog_masonry_gallery_read_more_button_icon_container
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$blog_masonry_gallery_read_more_button_icon_pack_hide_array = array();
$blog_masonry_gallery_read_more_button_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$blog_masonry_gallery_read_more_button_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$blog_masonry_gallery_read_more_button_icon_pack_hide_array[ $dep_collection_key ] = '';
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$blog_masonry_gallery_read_more_button_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_blog_masonry_gallery_read_more_button_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $blog_masonry_gallery_read_more_button_icon_collections_params as $blog_masonry_gallery_read_more_button_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $blog_masonry_gallery_read_more_button_icon_collections_param !== $dep_collection_object->param ) {
				$blog_masonry_gallery_read_more_button_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_blog_masonry_gallery_read_more_button_icon_' . $blog_masonry_gallery_read_more_button_icon_collections_param . '_container,';
			}
		}
		
		//remove remaining ',' character
		$blog_masonry_gallery_read_more_button_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$blog_masonry_gallery_read_more_button_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$blog_masonry_gallery_read_more_button_icon_pack = new HudsonEdgeField(
	"select",
	"blog_masonry_gallery_read_more_button_icon_pack",
	"font_awesome",
	esc_html__( "Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for show load more button", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		"dependence" => true,
		"hide"       => $blog_masonry_gallery_read_more_button_icon_pack_hide_array,
		"show"       => $blog_masonry_gallery_read_more_button_icon_pack_show_array
	)
);

$blog_masonry_gallery_read_more_button_icon_container->addChild(
	"blog_masonry_gallery_read_more_button_icon_pack",
	$blog_masonry_gallery_read_more_button_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$blog_masonry_gallery_read_more_button_icon_hide_values = $icon_collections_keys;
		$blog_icon_container                                    = new HudsonEdgeContainer(
			"blog_masonry_gallery_read_more_button_icon_" . $collection_object->param . "_container",
			"blog_masonry_gallery_read_more_button_icon_pack",
			"",
			$blog_masonry_gallery_read_more_button_icon_hide_values
		);
		$blog_masonry_gallery_read_more_button_icon             = new HudsonEdgeField(
			"select",
			"blog_masonry_gallery_read_more_button_icon_" . $collection_object->param,
			"",
			esc_html__( "Button Icon", 'hudson' ),
			esc_html__( "Choose Button Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$blog_icon_container->addChild(
			"blog_masonry_gallery_read_more_button_icon_" . $collection_object->param,
			$blog_masonry_gallery_read_more_button_icon
		);
		
		$blog_masonry_gallery_read_more_button_icon_container->addChild(
			"blog_masonry_gallery_read_more_button_icon_" . $collection_object->param . "_container",
			$blog_icon_container
		);
	}
	
}

$pagination_masonry_gallery = new HudsonEdgeField(
	"select",
	"pagination_masonry_gallery",
	"pagination",
	esc_html__( "Pagination on Masonry", 'hudson' ),
	esc_html__( 'Choose a pagination style for "Masonry" Blog List', 'hudson' ),
	array(
		"pagination" => esc_html__( "Pagination", 'hudson' ),
		"load_more" => esc_html__( "Load More", 'hudson' ),
		"infinite_scroll" => esc_html__( "Infinite Scroll", 'hudson' )
	)
);
$panel23->addChild(
	"pagination_masonry_gallery",
	$pagination_masonry_gallery
);

$blog_masonry_gallery_columns = new HudsonEdgeField(
	'select',
	'blog_masonry_gallery_columns',
	'two_columns',
	esc_html__( 'Masonry Blog Columns', 'hudson' ),
	esc_html__( 'Choose a number of columns for "Masonry" Blog List without sidebar', 'hudson' ),
	array(
		'two_columns'   => '2',
		'three_columns' => '3',
		'four_columns'  => '4'
	)
);
$panel23->addChild(
	'blog_masonry_gallery_columns',
	$blog_masonry_gallery_columns
);

$blog_masonry_gallery_full_width_columns = new HudsonEdgeField(
	'select',
	'blog_masonry_gallery_full_width_columns',
	'three_columns',
	esc_html__( 'Full Width Masonry Blog Columns', 'hudson' ),
	esc_html__( 'Choose a number of columns for "Masonry" Blog List', 'hudson' ),
	array(
		'three_columns' => '3',
		'four_columns'  => '4',
		'five_columns'  => '5'
	)
);
$panel23->addChild(
	'blog_masonry_gallery_full_width_columns',
	$blog_masonry_gallery_full_width_columns
);

$blog_masonry_gallery_full_width_margin = new HudsonEdgeField(
	"text",
	"blog_masonry_gallery_full_width_margin",
	"",
	esc_html__( "Full Width Masonry Margin", 'hudson' ),
	esc_html__( 'Please insert margin in px i.e. 5px, or in % i.e 5%', 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel23->addChild(
	"blog_masonry_gallery_full_width_margin",
	$blog_masonry_gallery_full_width_margin
);

$blog_masonry_gallery_filter = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_filter",
	"no",
	esc_html__( "Show Category Filter on Masonry", 'hudson' ),
	esc_html__( 'Enabling this option will display a Category Filter on "Masonry" Blog List', 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_gallery_filter_container"
	)
);
$panel23->addChild(
	"blog_masonry_gallery_filter",
	$blog_masonry_gallery_filter
);

$blog_masonry_gallery_filter_container = new HudsonEdgeContainer(
	"blog_masonry_gallery_filter_container",
	"blog_masonry_gallery_filter",
	"no"
);
$panel23->addChild(
	"blog_masonry_gallery_filter_container",
	$blog_masonry_gallery_filter_container
);

// Blog Masonry Filter
$blog_masonry_gallery_filter_background_color = new HudsonEdgeField(
	"color",
	"blog_masonry_gallery_filter_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose color for background of filter area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_gallery_filter_container->addChild(
	"blog_masonry_gallery_filter_background_color",
	$blog_masonry_gallery_filter_background_color
);

$blog_masonry_gallery_filter_height = new HudsonEdgeField(
	"text",
	"blog_masonry_gallery_filter_height",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "Enter height for filter area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_gallery_filter_container->addChild(
	"blog_masonry_gallery_filter_height",
	$blog_masonry_gallery_filter_height
);

$blog_masonry_gallery_filter_margin_bottom = new HudsonEdgeField(
	"text",
	"blog_masonry_gallery_filter_margin_bottom",
	"",
	esc_html__( "Bottom Margin (px)", 'hudson' ),
	esc_html__( "Enter bottom margin for filter area. Default value is 36", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$blog_masonry_gallery_filter_container->addChild(
	"blog_masonry_gallery_filter_margin_bottom",
	$blog_masonry_gallery_filter_margin_bottom
);

$blog_masonry_gallery_filter_alignment = new HudsonEdgeField(
	"select",
	"blog_masonry_gallery_filter_alignment",
	"",
	esc_html__( "Horizontal Alignment", 'hudson' ),
	esc_html__( "Choose filter alignment", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$blog_masonry_gallery_filter_container->addChild(
	"blog_masonry_gallery_filter_alignment",
	$blog_masonry_gallery_filter_alignment
);

$blog_masonry_gallery_enable_filter_title = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_enable_filter_title",
	"no",
	esc_html__( "Enable Filter Title", 'hudson' ),
	esc_html__( "Enabling this option will show category filter title", 'hudson' )
);
$blog_masonry_gallery_filter_container->addChild(
	"blog_masonry_gallery_enable_filter_title",
	$blog_masonry_gallery_enable_filter_title
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Title", 'hudson' ),
	esc_html__( "Define text styles for filter title", 'hudson' )
);
$blog_masonry_gallery_filter_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$blog_masonry_gallery_filter_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_filter_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_title_color",
	$blog_masonry_gallery_filter_title_color
);
$blog_masonry_gallery_filter_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_filter_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_title_font_size",
	$blog_masonry_gallery_filter_title_font_size
);
$blog_masonry_gallery_filter_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_filter_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_title_line_height",
	$blog_masonry_gallery_filter_title_line_height
);
$blog_masonry_gallery_filter_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_filter_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"blog_masonry_gallery_filter_title_text_transform",
	$blog_masonry_gallery_filter_title_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);
$blog_masonry_gallery_filter_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_gallery_filter_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_filter_title_font_family",
	$blog_masonry_gallery_filter_title_font_family
);
$blog_masonry_gallery_filter_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_filter_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_gallery_filter_title_font_style",
	$blog_masonry_gallery_filter_title_font_style
);
$blog_masonry_gallery_filter_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_filter_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_gallery_filter_title_font_weight",
	$blog_masonry_gallery_filter_title_font_weight
);
$blog_masonry_gallery_filter_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_filter_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_filter_title_letter_spacing",
	$blog_masonry_gallery_filter_title_letter_spacing
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Categories", 'hudson' ),
	esc_html__( "Define text styles for filter categories", 'hudson' )
);
$blog_masonry_gallery_filter_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);
$blog_masonry_gallery_filter_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_filter_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_color",
	$blog_masonry_gallery_filter_color
);
$blog_masonry_gallery_filter_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_filter_hovercolor",
	"",
	esc_html__( "Hover/Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_hovercolor",
	$blog_masonry_gallery_filter_hovercolor
);
$blog_masonry_gallery_filter_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_filter_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_font_size",
	$blog_masonry_gallery_filter_font_size
);
$blog_masonry_gallery_filter_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_filter_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_filter_line_height",
	$blog_masonry_gallery_filter_line_height
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);
$blog_masonry_gallery_filter_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_gallery_filter_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_filter_font_family",
	$blog_masonry_gallery_filter_font_family
);
$blog_masonry_gallery_filter_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_filter_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_gallery_filter_font_style",
	$blog_masonry_gallery_filter_font_style
);
$blog_masonry_gallery_filter_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_filter_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_masonry_gallery_filter_font_weight",
	$blog_masonry_gallery_filter_font_weight
);
$blog_masonry_gallery_filter_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_filter_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_masonry_gallery_filter_text_transform",
	$blog_masonry_gallery_filter_text_transform
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$blog_masonry_gallery_filter_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_filter_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_gallery_filter_letter_spacing",
	$blog_masonry_gallery_filter_letter_spacing
);

$blog_masonry_gallery_filter_disable_separator = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_filter_disable_separator",
	"yes",
	esc_html__( "Disable Separator Between Categories", 'hudson' ),
	esc_html__( "Disabling this option will remove separator between filter categories.", 'hudson' )
);
$blog_masonry_gallery_filter_container->addChild(
	"blog_masonry_gallery_filter_disable_separator",
	$blog_masonry_gallery_filter_disable_separator
);

$blog_masonry_gallery_content_position = new HudsonEdgeField(
	"select",
	"blog_masonry_gallery_content_position",
	"content_above_blog_list",
	esc_html__( "Content Position", 'hudson' ),
	esc_html__( "Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", 'hudson' ),
	array(
		"content_above_blog_list" => esc_html__( "Content Above Blog List", 'hudson' ),
		"content_above_blog_list_and_sidebar" => esc_html__( "Content Above Blog List and Sidebar", 'hudson' )
	)
);
$panel23->addChild(
	"blog_masonry_gallery_content_position",
	$blog_masonry_gallery_content_position
);

$blog_masonry_gallery_post_meta_data_section = new HudsonEdgeTitle(
	"blog_masonry_gallery_post_meta_data_section",
	esc_html__( "Post Info Data Fields", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_post_meta_data_section",
	$blog_masonry_gallery_post_meta_data_section
);

$blog_masonry_gallery_show_categories = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_categories",
	"no",
	esc_html__( "Show Categories", 'hudson' ),
	esc_html__( "Enabling this option will Show Categories on Post List", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_show_categories",
	$blog_masonry_gallery_show_categories
);

$blog_masonry_gallery_show_comments = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_comments",
	"no",
	esc_html__( "Show Comments", 'hudson' ),
	esc_html__( "Enabling this option will Show Comments on Post List", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_show_comments",
	$blog_masonry_gallery_show_comments
);

$blog_masonry_gallery_show_author = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_author",
	"no",
	esc_html__( "Show Author Name", 'hudson' ),
	esc_html__( "Enabling this option will show author name on Post List and Blog Post Single", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_show_author",
	$blog_masonry_gallery_show_author
);

$blog_masonry_gallery_show_date = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_date",
	"no",
	esc_html__( "Show Date", 'hudson' ),
	esc_html__( "Enabling this option will show date on Post List", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_show_date",
	$blog_masonry_gallery_show_date
);

$blog_masonry_gallery_show_share = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_share",
	"no",
	esc_html__( "Show Share", 'hudson' ),
	esc_html__( "Enabling this option will show share on Post List", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_gallery_share_options_container"
	)
);
$panel23->addChild(
	"blog_masonry_gallery_show_share",
	$blog_masonry_gallery_show_share
);

$blog_masonry_gallery_share_options_container = new HudsonEdgeContainer(
	"blog_masonry_gallery_share_options_container",
	"blog_masonry_gallery_show_share",
	"no"
);
$panel23->addChild(
	"blog_masonry_gallery_share_options_container",
	$blog_masonry_gallery_share_options_container
);

$blog_masonry_gallery_select_share_options_masonry_type = new HudsonEdgeField(
	"select",
	"blog_masonry_gallery_select_share_options_masonry_type",
	"dropdown",
	esc_html__( "Social Share Style", 'hudson' ),
	esc_html__( "Choose Social Share Style for Masonry Type", 'hudson' ),
	array(
		"dropdown" => esc_html__( "Social Share Dropdown", 'hudson' ),
		"list" => esc_html__( "Social Share List", 'hudson' )
	)
);

$blog_masonry_gallery_share_options_container->addChild(
	"blog_masonry_gallery_select_share_options_masonry_type",
	$blog_masonry_gallery_select_share_options_masonry_type
);

$blog_masonry_gallery_share_icon_color = new HudsonEdgeField(
	"color",
	"blog_masonry_gallery_share_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for share dropdown", 'hudson' )
);
$blog_masonry_gallery_share_options_container->addChild(
	"blog_masonry_gallery_share_icon_color",
	$blog_masonry_gallery_share_icon_color
);

$blog_masonry_gallery_share_hld_hover_icon_color = new HudsonEdgeField(
	"color",
	"blog_masonry_gallery_share_hld_hover_icon_color",
	"",
	esc_html__( "Icon color on Quote/Link Holder Hover", 'hudson' ),
	esc_html__( "Choose icon color for share dropdown when the quote/link holder is hovered over", 'hudson' )
);
$blog_masonry_gallery_share_options_container->addChild(
	"blog_masonry_gallery_share_hld_hover_icon_color",
	$blog_masonry_gallery_share_hld_hover_icon_color
);

$blog_masonry_gallery_share_icon_hover_color = new HudsonEdgeField(
	"color",
	"blog_masonry_gallery_share_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose icon hover color for share dropdown", 'hudson' )
);
$blog_masonry_gallery_share_options_container->addChild(
	"blog_masonry_gallery_share_icon_hover_color",
	$blog_masonry_gallery_share_icon_hover_color
);

$blog_masonry_gallery_share_background_color = new HudsonEdgeField(
	"color",
	"blog_masonry_gallery_share_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for share dropdown list field", 'hudson' )
);
$blog_masonry_gallery_share_options_container->addChild(
	"blog_masonry_gallery_share_background_color",
	$blog_masonry_gallery_share_background_color
);

$blog_masonry_gallery_show_like = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_like",
	"no",
	esc_html__( "Show Likes", 'hudson' ),
	esc_html__( 'Enabling this option will turn on "Likes"', 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_show_like",
	$blog_masonry_gallery_show_like
);

$blog_masonry_gallery_show_small_separator = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_small_separator",
	"no",
	esc_html__( "Show Small Separator", 'hudson' ),
	esc_html__( "Enabling this option will show small separator below title", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_show_small_separator",
	$blog_masonry_gallery_show_small_separator
);

$blog_masonry_gallery_post_design_style = new HudsonEdgeTitle(
	"blog_masonry_gallery_post_design_style",
	esc_html__( "Post Design Style", 'hudson' )
);
$panel23->addChild(
	"blog_masonry_gallery_post_design_style",
	$blog_masonry_gallery_post_design_style
);

$blog_masonry_gallery_post_alignment = new HudsonEdgeField(
	"select",
	"blog_masonry_gallery_post_alignment",
	"center",
	esc_html__( "Post Alignment", 'hudson' ),
	esc_html__( "Choose alignment for whole post", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$panel23->addChild(
	"blog_masonry_gallery_post_alignment",
	$blog_masonry_gallery_post_alignment
);

$blog_masonry_gallery_show_article_icon = new HudsonEdgeField(
	"yesno",
	"blog_masonry_gallery_show_article_icon",
	"yes",
	esc_html__( "Enable Article Icon", 'hudson' ),
	esc_html__( "Enabling this option will show article icon", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_blog_masonry_gallery_show_article_icon_container"
	)
);
$panel23->addChild(
	"blog_masonry_gallery_show_article_icon",
	$blog_masonry_gallery_show_article_icon
);

$blog_masonry_gallery_show_article_icon_container = new HudsonEdgeContainer(
	"blog_masonry_gallery_show_article_icon_container",
	"blog_masonry_gallery_show_article_icon",
	"no"
);
$panel23->addChild(
	"blog_masonry_gallery_show_article_icon_container",
	$blog_masonry_gallery_show_article_icon_container
);

$blog_masonry_gallery_icon_style_group = new HudsonEdgeGroup(
	esc_html__( "Icon Style", 'hudson' ),
	esc_html__( "Define icon style for articles", 'hudson' )
);
$blog_masonry_gallery_show_article_icon_container->addChild(
	"blog_masonry_gallery_icon_style_group",
	$blog_masonry_gallery_icon_style_group
);

$row1 = new HudsonEdgeRow();
$blog_masonry_gallery_icon_style_group->addChild(
	"row1",
	$row1
);

$blog_masonry_gallery_article_mark_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_article_mark_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_article_mark_color",
	$blog_masonry_gallery_article_mark_color
);

$blog_masonry_gallery_article_mark_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_article_mark_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose hover icon color", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_article_mark_hover_color",
	$blog_masonry_gallery_article_mark_hover_color
);

$blog_masonry_gallery_ql_article_mark_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_article_mark_color",
	"",
	esc_html__( "Quote/Link Icon Color", 'hudson' ),
	esc_html__( "Choose icon color", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_ql_article_mark_color",
	$blog_masonry_gallery_ql_article_mark_color
);

$blog_masonry_gallery_ql_article_mark_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_article_mark_hover_color",
	"",
	esc_html__( "Quote/Link Icon Hover Color", 'hudson' ),
	esc_html__( "Choose hover icon color", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_ql_article_mark_hover_color",
	$blog_masonry_gallery_ql_article_mark_hover_color
);

$blog_masonry_gallery_overlay_group = new HudsonEdgeGroup(
	esc_html__( 'Overlay Style', 'hudson' ),
	esc_html__( 'Define Overlay Style', 'hudson' )
);
$panel23->addChild(
	'blog_masonry_gallery_overlay_group',
	$blog_masonry_gallery_overlay_group
);

$row1 = new HudsonEdgeRow();
$blog_masonry_gallery_overlay_group->addChild(
	'row1',
	$row1
);

$blog_masonry_gallery_overlay_color = new HudsonEdgeField(
	'colorsimple',
	'blog_masonry_gallery_overlay_color',
	'',
	esc_html__( 'Color', 'hudson' )
);
$row1->addChild(
	'blog_masonry_gallery_overlay_color',
	$blog_masonry_gallery_overlay_color
);

$blog_masonry_gallery_overlay_hover_color = new HudsonEdgeField(
	'colorsimple',
	'blog_masonry_gallery_overlay_hover_color',
	'',
	esc_html__( 'Hover Color', 'hudson' )
);
$row1->addChild(
	'blog_masonry_gallery_overlay_hover_color',
	$blog_masonry_gallery_overlay_hover_color
);

$blog_masonry_gallery_overlay_transparency = new HudsonEdgeField(
	'textsimple',
	'blog_masonry_gallery_overlay_transparency',
	'',
	esc_html__( 'Transparency (0=full - 1=opaque)', 'hudson' )
);
$row1->addChild(
	'blog_masonry_gallery_overlay_transparency',
	$blog_masonry_gallery_overlay_transparency
);

$blog_masonry_gallery_overlay_hover_transparency = new HudsonEdgeField(
	'textsimple',
	'blog_masonry_gallery_overlay_hover_transparency',
	'',
	esc_html__( 'Hover Transparency (0=full - 1=opaque)', 'hudson' )
);
$row1->addChild(
	'blog_masonry_gallery_overlay_hover_transparency',
	$blog_masonry_gallery_overlay_hover_transparency
);

$blog_masonry_gallery_ql_overlay_group = new HudsonEdgeGroup(
	esc_html__( 'Quote/Link Overlay Style', 'hudson' ),
	esc_html__( 'Define overlay style for quote and link posts', 'hudson' )
);
$panel23->addChild(
	'blog_masonry_gallery_ql_overlay_group',
	$blog_masonry_gallery_ql_overlay_group
);

$row1 = new HudsonEdgeRow();
$blog_masonry_gallery_ql_overlay_group->addChild(
	"row1",
	$row1
);

$blog_masonry_gallery_ql_overlay_color = new HudsonEdgeField(
	'colorsimple',
	'blog_masonry_gallery_ql_overlay_color',
	'',
	esc_html__( 'Color', 'hudson' )
);
$row1->addChild(
	'blog_masonry_gallery_ql_overlay_color',
	$blog_masonry_gallery_ql_overlay_color
);

$blog_masonry_gallery_ql_overlay_hover_color = new HudsonEdgeField(
	'colorsimple',
	'blog_masonry_gallery_ql_overlay_hover_color',
	'',
	esc_html__( 'Hover Color', 'hudson' )
);
$row1->addChild(
	'blog_masonry_gallery_ql_overlay_hover_color',
	$blog_masonry_gallery_ql_overlay_hover_color
);

$blog_masonry_gallery_ql_border_pattern = new HudsonEdgeField(
	"imagesimple",
	"blog_masonry_gallery_ql_border_pattern",
	"",
	esc_html__( "Border Pattern", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_ql_border_pattern",
	$blog_masonry_gallery_ql_border_pattern
);

$blog_masonry_gallery_ql_border_width = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_ql_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_ql_border_width",
	$blog_masonry_gallery_ql_border_width
);

$group8 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Set spacing for blog layouts", 'hudson' )
);
$panel23->addChild(
	"group8",
	$group8
);

$row1 = new HudsonEdgeRow();
$group8->addChild(
	"row1",
	$row1
);

$blog_masonry_gallery_icon_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_icon_margin_bottom",
	"",
	esc_html__( "Margin Under Icon Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_icon_margin_bottom",
	$blog_masonry_gallery_icon_margin_bottom
);

$blog_masonry_gallery_post_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_post_info_margin_bottom",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_post_info_margin_bottom",
	$blog_masonry_gallery_post_info_margin_bottom
);

$blog_masonry_gallery_read_more_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_read_more_margin_top",
	"",
	esc_html__( "Margin Above Read More Button (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_read_more_margin_top",
	$blog_masonry_gallery_read_more_margin_top
);

$blog_masonry_gallery_social_share_list_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_social_share_list_margin_top",
	"",
	esc_html__( "Margin Above Social Share List Holder (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_social_share_list_margin_top",
	$blog_masonry_gallery_social_share_list_margin_top
);

$post_text_styling = new HudsonEdgeTitle(
	"post_text_styling",
	esc_html__( "Post Text Style", 'hudson' )
);
$panel23->addChild(
	"post_text_styling",
	$post_text_styling
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Post Title", 'hudson' ),
	esc_html__( "Define title styles in this blog post template.", 'hudson' )
);
$panel23->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$blog_masonry_gallery_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_title_color",
	$blog_masonry_gallery_title_color
);

$blog_masonry_gallery_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_title_hover_color",
	$blog_masonry_gallery_title_hover_color
);

$blog_masonry_gallery_ql_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_title_color",
	"",
	esc_html__( "Quote/Link Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_ql_title_color",
	$blog_masonry_gallery_ql_title_color
);

$blog_masonry_gallery_ql_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_title_hover_color",
	"",
	esc_html__( "Quote/Link Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_ql_title_hover_color",
	$blog_masonry_gallery_ql_title_hover_color
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$blog_masonry_gallery_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_title_fontsize",
	$blog_masonry_gallery_title_fontsize
);

$blog_masonry_gallery_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_title_lineheight",
	$blog_masonry_gallery_title_lineheight
);

$blog_masonry_gallery_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_gallery_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_title_google_fonts",
	$blog_masonry_gallery_title_google_fonts
);

$blog_masonry_gallery_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_masonry_gallery_title_fontstyle",
	$blog_masonry_gallery_title_fontstyle
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$blog_masonry_gallery_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"blog_masonry_gallery_title_fontweight",
	$blog_masonry_gallery_title_fontweight
);

$blog_masonry_gallery_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"blog_masonry_gallery_title_texttransform",
	$blog_masonry_gallery_title_texttransform
);

$blog_masonry_gallery_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_gallery_title_letterspacing",
	$blog_masonry_gallery_title_letterspacing
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Post Info Data", 'hudson' ),
	esc_html__( "Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list", 'hudson' )
);
$panel23->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);

$blog_masonry_gallery_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_info_color",
	$blog_masonry_gallery_info_color
);

$blog_masonry_gallery_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_info_link_color",
	$blog_masonry_gallery_info_link_color
);

$blog_masonry_gallery_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_info_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_masonry_gallery_info_hover_color",
	$blog_masonry_gallery_info_hover_color
);

$row2 = new HudsonEdgeRow( true );
$group4->addChild(
	"row2",
	$row2
);

$blog_masonry_gallery_ql_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_info_color",
	"",
	esc_html__( "Quote/Link Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_ql_info_color",
	$blog_masonry_gallery_ql_info_color
);

$blog_masonry_gallery_ql_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_info_link_color",
	"",
	esc_html__( "Quote/Link Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_ql_info_link_color",
	$blog_masonry_gallery_ql_info_link_color
);

$blog_masonry_gallery_ql_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_masonry_gallery_ql_info_hover_color",
	"",
	esc_html__( "Quote/Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_masonry_gallery_ql_info_hover_color",
	$blog_masonry_gallery_ql_info_hover_color
);

$row3 = new HudsonEdgeRow( true );
$group4->addChild(
	"row3",
	$row3
);

$blog_masonry_gallery_info_fontsize = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_info_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_gallery_info_fontsize",
	$blog_masonry_gallery_info_fontsize
);

$blog_masonry_gallery_info_lineheight = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_info_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_gallery_info_lineheight",
	$blog_masonry_gallery_info_lineheight
);

$blog_masonry_gallery_info_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"blog_masonry_gallery_info_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_masonry_gallery_info_google_fonts",
	$blog_masonry_gallery_info_google_fonts
);

$blog_masonry_gallery_info_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_info_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"blog_masonry_gallery_info_fontstyle",
	$blog_masonry_gallery_info_fontstyle
);

$row4 = new HudsonEdgeRow( true );
$group4->addChild(
	"row4",
	$row4
);

$blog_masonry_gallery_info_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_info_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row4->addChild(
	"blog_masonry_gallery_info_fontweight",
	$blog_masonry_gallery_info_fontweight
);

$blog_masonry_gallery_info_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_masonry_gallery_info_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row4->addChild(
	"blog_masonry_gallery_info_texttransform",
	$blog_masonry_gallery_info_texttransform
);

$blog_masonry_gallery_info_letterspacing = new HudsonEdgeField(
	"textsimple",
	"blog_masonry_gallery_info_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"blog_masonry_gallery_info_letterspacing",
	$blog_masonry_gallery_info_letterspacing
);

//Blog List

$panel28 = new HudsonEdgePanel(
	esc_html__( "Blog List Shortcode", 'hudson' ),
	"blog_list_panel"
);
$blogPage->addChild(
	"panel28",
	$panel28
);

//Blog List Boxes

$blog_list_boxes_section_subtitle = new HudsonEdgeTitle(
	"blog_list_boxes_section_subtitle",
	esc_html__( "Blog List - Boxes", 'hudson' )
);
$panel28->addChild(
	"blog_list_boxes_section_subtitle",
	$blog_list_boxes_section_subtitle
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Blog List Padding", 'hudson' ),
	esc_html__( "Enter Boxes Blog List padding", 'hudson' )
);
$panel28->addChild(
	"group6",
	$group6
);
$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$blog_list_boxes_padding_top = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_padding_top",
	"",
	esc_html__( "Padding Top (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_padding_top",
	$blog_list_boxes_padding_top
);

$blog_list_boxes_padding_right = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_padding_right",
	$blog_list_boxes_padding_right
);

$blog_list_boxes_padding_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_padding_bottom",
	"",
	esc_html__( "Padding Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_padding_bottom",
	$blog_list_boxes_padding_bottom
);

$blog_list_boxes_padding_left = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_padding_left",
	$blog_list_boxes_padding_left
);

$group16 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Define blog list spacing", 'hudson' )
);
$panel28->addChild(
	"group16",
	$group16
);

$row1 = new HudsonEdgeRow();
$group16->addChild(
	"row1",
	$row1
);

$blog_list_boxes_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_title_margin_bottom",
	$blog_list_boxes_title_margin_bottom
);

$blog_list_boxes_post_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_post_info_margin_bottom",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_post_info_margin_bottom",
	$blog_list_boxes_post_info_margin_bottom
);

$blog_list_boxes_read_more_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_read_more_margin_top",
	"",
	esc_html__( "Margin Above Read More Button (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_read_more_margin_top",
	$blog_list_boxes_read_more_margin_top
);

$group17 = new HudsonEdgeGroup(
	esc_html__( "Blog List Title", 'hudson' ),
	esc_html__( "Define Blog List title style", 'hudson' )
);
$panel28->addChild(
	"group17",
	$group17
);

$row1 = new HudsonEdgeRow();
$group17->addChild(
	"row1",
	$row1
);

$blog_list_boxes_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_boxes_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_title_color",
	$blog_list_boxes_title_color
);

$blog_list_boxes_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_boxes_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_title_hover_color",
	$blog_list_boxes_title_hover_color
);

$blog_list_boxes_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_title_font_size",
	$blog_list_boxes_title_font_size
);

$blog_list_boxes_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_title_line_height",
	$blog_list_boxes_title_line_height
);

$row2 = new HudsonEdgeRow();
$group17->addChild(
	"row2",
	$row2
);

$blog_list_boxes_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_boxes_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_list_boxes_title_text_transform",
	$blog_list_boxes_title_text_transform
);

$blog_list_boxes_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_list_boxes_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_boxes_title_font_family",
	$blog_list_boxes_title_font_family
);

$blog_list_boxes_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_boxes_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_list_boxes_title_font_style",
	$blog_list_boxes_title_font_style
);

$blog_list_boxes_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_boxes_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_list_boxes_title_font_weight",
	$blog_list_boxes_title_font_weight
);

$row3 = new HudsonEdgeRow();
$group17->addChild(
	"row3",
	$row3
);

$blog_list_boxes_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_list_boxes_title_letter_spacing",
	$blog_list_boxes_title_letter_spacing
);

$group18 = new HudsonEdgeGroup(
	esc_html__( "Blog List Post Info", 'hudson' ),
	esc_html__( "Define blog list post info style", 'hudson' )
);
$panel28->addChild(
	"group18",
	$group18
);

$row1 = new HudsonEdgeRow();
$group18->addChild(
	"row1",
	$row1
);

$blog_list_boxes_post_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_boxes_post_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_post_info_color",
	$blog_list_boxes_post_info_color
);

$blog_list_boxes_post_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_boxes_post_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_post_info_link_color",
	$blog_list_boxes_post_info_link_color
);

$blog_list_boxes_post_info_link_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_boxes_post_info_link_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_post_info_link_hover_color",
	$blog_list_boxes_post_info_link_hover_color
);

$blog_list_boxes_post_info_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_post_info_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_post_info_font_size",
	$blog_list_boxes_post_info_font_size
);

$row2 = new HudsonEdgeRow();
$group18->addChild(
	"row2",
	$row2
);

$blog_list_boxes_post_info_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_post_info_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_boxes_post_info_line_height",
	$blog_list_boxes_post_info_line_height
);

$blog_list_boxes_post_info_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_boxes_post_info_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_list_boxes_post_info_text_transform",
	$blog_list_boxes_post_info_text_transform
);

$blog_list_boxes_post_info_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_list_boxes_post_info_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_boxes_post_info_font_family",
	$blog_list_boxes_post_info_font_family
);

$blog_list_boxes_post_info_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_boxes_post_info_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_list_boxes_post_info_font_style",
	$blog_list_boxes_post_info_font_style
);

$row3 = new HudsonEdgeRow();
$group18->addChild(
	"row3",
	$row3
);

$blog_list_boxes_post_info_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_boxes_post_info_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"blog_list_boxes_post_info_font_weight",
	$blog_list_boxes_post_info_font_weight
);

$blog_list_boxes_post_info_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_list_boxes_post_info_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_list_boxes_post_info_letter_spacing",
	$blog_list_boxes_post_info_letter_spacing
);

$group23 = new HudsonEdgeGroup(
	esc_html__( "Blog List Date/Day Style", 'hudson' ),
	esc_html__( "Define blog list date/day style (day style for default date position)", 'hudson' )
);
$panel28->addChild(
	"group23",
	$group23
);

$row1 = new HudsonEdgeRow();
$group23->addChild(
	"row1",
	$row1
);

$blog_list_boxes_date_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_boxes_date_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_date_color",
	$blog_list_boxes_date_color
);

$blog_list_boxes_date_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_list_boxes_date_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_boxes_date_font_family",
	$blog_list_boxes_date_font_family
);

$blog_list_minimal_subtitle = new HudsonEdgeTitle(
	"blog_list_minimal_subtitle",
	esc_html__( "Blog List - Minimal", 'hudson' )
);
$panel28->addChild(
	"blog_list_minimal_subtitle",
	$blog_list_minimal_subtitle
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Define blog list spacing", 'hudson' )
);
$panel28->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow( true );
$group5->addChild(
	"row1",
	$row1
);

$blog_list_minimal_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_list_minimal_title_margin_bottom",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_minimal_title_margin_bottom",
	$blog_list_minimal_title_margin_bottom
);

$blog_list_minimal_post_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"blog_list_minimal_post_info_margin_bottom",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_minimal_post_info_margin_bottom",
	$blog_list_minimal_post_info_margin_bottom
);

$blog_list_minimal_read_more_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_list_minimal_read_more_margin_top",
	"",
	esc_html__( "Margin Above Read More Button (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_minimal_read_more_margin_top",
	$blog_list_minimal_read_more_margin_top
);

$blog_list_masonry_subtitle = new HudsonEdgeTitle(
	'blog_list_masonry_subtitle',
	esc_html__( 'Blog List - Masonry', 'hudson' )
);
$panel28->addChild(
	'blog_list_masonry_subtitle',
	$blog_list_masonry_subtitle
);

$group19 = new HudsonEdgeGroup(
	esc_html__( 'Blog List Padding', 'hudson' ),
	esc_html__( 'Enter Boxes Blog List padding', 'hudson' )
);
$panel28->addChild(
	'group19',
	$group19
);

$row1 = new HudsonEdgeRow();
$group19->addChild(
	'row1',
	$row1
);

$blog_list_masonry_padding_top = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_padding_top',
	'',
	esc_html__( 'Padding Top (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_padding_top',
	$blog_list_masonry_padding_top
);

$blog_list_masonry_padding_right = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_padding_right',
	'',
	esc_html__( 'Padding Right (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_padding_right',
	$blog_list_masonry_padding_right
);

$blog_list_masonry_padding_bottom = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_padding_bottom',
	'',
	esc_html__( 'Padding Bottom (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_padding_bottom',
	$blog_list_masonry_padding_bottom
);

$blog_list_masonry_padding_left = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_padding_left',
	'',
	esc_html__( 'Padding Left (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_padding_left',
	$blog_list_masonry_padding_left
);

$group20 = new HudsonEdgeGroup(
	esc_html__( 'Blog List Spacing', 'hudson' ),
	esc_html__( 'Define blog list spacing', 'hudson' )
);
$panel28->addChild(
	'group20',
	$group20
);

$row2 = new HudsonEdgeRow();
$group20->addChild(
	'row2',
	$row2
);

$blog_list_masonry_title_margin_bottom = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_title_margin_bottom',
	'',
	esc_html__( 'Margin Under Title (px)', 'hudson' ),
	''
);
$row2->addChild(
	'blog_list_masonry_title_margin_bottom',
	$blog_list_masonry_title_margin_bottom
);

$blog_list_masonry_post_info_margin_bottom = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_post_info_margin_bottom',
	'',
	esc_html__( 'Margin Under Post Info (px)', 'hudson' ),
	''
);
$row2->addChild(
	'blog_list_masonry_post_info_margin_bottom',
	$blog_list_masonry_post_info_margin_bottom
);

$group21 = new HudsonEdgeGroup(
	esc_html__( 'Blog List Title', 'hudson' ),
	esc_html__( 'Define Blog List title style', 'hudson' )
);
$panel28->addChild(
	'group21',
	$group21
);

$row1 = new HudsonEdgeRow();
$group21->addChild(
	'row1',
	$row1
);

$blog_list_masonry_title_color = new HudsonEdgeField(
	'colorsimple',
	'blog_list_masonry_title_color',
	'',
	esc_html__( 'Text Color', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_title_color',
	$blog_list_masonry_title_color
);

$blog_list_masonry_title_hover_color = new HudsonEdgeField(
	'colorsimple',
	'blog_list_masonry_title_hover_color',
	'',
	esc_html__( 'Text Hover Color', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_title_hover_color',
	$blog_list_masonry_title_hover_color
);

$blog_list_masonry_title_font_size = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_title_font_size',
	'',
	esc_html__( 'Font Size (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_title_font_size',
	$blog_list_masonry_title_font_size
);

$blog_list_masonry_title_line_height = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_title_line_height',
	'',
	esc_html__( 'Line Height (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_title_line_height',
	$blog_list_masonry_title_line_height
);

$row2 = new HudsonEdgeRow();
$group21->addChild(
	'row2',
	$row2
);

$blog_list_masonry_title_text_transform = new HudsonEdgeField(
	'selectblanksimple',
	'blog_list_masonry_title_text_transform',
	'',
	esc_html__( 'Text Transform', 'hudson' ),
	'',
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	'blog_list_masonry_title_text_transform',
	$blog_list_masonry_title_text_transform
);

$blog_list_masonry_title_font_family = new HudsonEdgeField(
	'fontsimple',
	'blog_list_masonry_title_font_family',
	'-1',
	esc_html__( 'Font Family', 'hudson' ),
	''
);
$row2->addChild(
	'blog_list_masonry_title_font_family',
	$blog_list_masonry_title_font_family
);

$blog_list_masonry_title_font_style = new HudsonEdgeField(
	'selectblanksimple',
	'blog_list_masonry_title_font_style',
	'',
	esc_html__( 'Font Style', 'hudson' ),
	'',
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	'blog_list_masonry_title_font_style',
	$blog_list_masonry_title_font_style
);

$blog_list_masonry_title_font_weight = new HudsonEdgeField(
	'selectblanksimple',
	'blog_list_masonry_title_font_weight',
	'',
	esc_html__( 'Font Weight', 'hudson' ),
	'',
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	'blog_list_masonry_title_font_weight',
	$blog_list_masonry_title_font_weight
);

$row3 = new HudsonEdgeRow();
$group21->addChild(
	'row3',
	$row3
);

$blog_list_masonry_title_letter_spacing = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_title_letter_spacing',
	'',
	esc_html__( 'Letter Spacing (px)', 'hudson' ),
	''
);
$row3->addChild(
	'blog_list_masonry_title_letter_spacing',
	$blog_list_masonry_title_letter_spacing
);

$group22 = new HudsonEdgeGroup(
	esc_html__( 'Blog List Post Info', 'hudson' ),
	esc_html__( 'Define blog list post info style', 'hudson' )
);
$panel28->addChild(
	'group22',
	$group22
);

$row1 = new HudsonEdgeRow();
$group22->addChild(
	'row1',
	$row1
);

$blog_list_masonry_date_color = new HudsonEdgeField(
	'colorsimple',
	'blog_list_masonry_date_color',
	'',
	esc_html__( 'Day Color', 'hudson' ),
	esc_html__( 'Choose color for day', 'hudson' )
);
$row1->addChild(
	'blog_list_masonry_date_color',
	$blog_list_masonry_date_color
);

$blog_list_masonry_post_info_link_color = new HudsonEdgeField(
	'colorsimple',
	'blog_list_masonry_post_info_link_color',
	'',
	esc_html__( 'Link Color', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_post_info_link_color',
	$blog_list_masonry_post_info_link_color
);

$blog_list_masonry_post_info_link_hover_color = new HudsonEdgeField(
	'colorsimple',
	'blog_list_masonry_post_info_link_hover_color',
	'',
	esc_html__( 'Link Hover Color', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_post_info_link_hover_color',
	$blog_list_masonry_post_info_link_hover_color
);

$blog_list_masonry_post_info_font_size = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_post_info_font_size',
	'',
	esc_html__( 'Font Size (px)', 'hudson' ),
	''
);
$row1->addChild(
	'blog_list_masonry_post_info_font_size',
	$blog_list_masonry_post_info_font_size
);

$row2 = new HudsonEdgeRow();
$group22->addChild(
	'row2',
	$row2
);

$blog_list_masonry_post_info_line_height = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_post_info_line_height',
	'',
	esc_html__( 'Line Height (px)', 'hudson' ),
	''
);
$row2->addChild(
	'blog_list_masonry_post_info_line_height',
	$blog_list_masonry_post_info_line_height
);

$blog_list_masonry_post_info_text_transform = new HudsonEdgeField(
	'selectblanksimple',
	'blog_list_masonry_post_info_text_transform',
	'',
	esc_html__( 'Text Transform', 'hudson' ),
	'',
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	'blog_list_masonry_post_info_text_transform',
	$blog_list_masonry_post_info_text_transform
);

$blog_list_masonry_post_info_font_family = new HudsonEdgeField(
	'fontsimple',
	'blog_list_masonry_post_info_font_family',
	'-1',
	esc_html__( 'Font Family', 'hudson' ),
	''
);
$row2->addChild(
	'blog_list_masonry_post_info_font_family',
	$blog_list_masonry_post_info_font_family
);

$blog_list_masonry_post_info_font_style = new HudsonEdgeField(
	'selectblanksimple',
	'blog_list_masonry_post_info_font_style',
	'',
	esc_html__( 'Font Style', 'hudson' ),
	'',
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	'blog_list_masonry_post_info_font_style',
	$blog_list_masonry_post_info_font_style
);

$row3 = new HudsonEdgeRow();
$group22->addChild(
	'row3',
	$row3
);

$blog_list_masonry_post_info_font_weight = new HudsonEdgeField(
	'selectblanksimple',
	'blog_list_masonry_post_info_font_weight',
	'',
	esc_html__( 'Font Weight', 'hudson' ),
	'',
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	'blog_list_masonry_post_info_font_weight',
	$blog_list_masonry_post_info_font_weight
);

$blog_list_masonry_post_info_letter_spacing = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_post_info_letter_spacing',
	'',
	esc_html__( 'Letter Spacing (px)', 'hudson' ),
	''
);
$row3->addChild(
	'blog_list_masonry_post_info_letter_spacing',
	$blog_list_masonry_post_info_letter_spacing
);

$blog_list_masonry_post_info_border_color = new HudsonEdgeField(
	'colorsimple',
	'blog_list_masonry_post_info_border_color',
	'',
	esc_html__( 'Border Color', 'hudson' ),
	''
);
$row3->addChild(
	'blog_list_masonry_post_info_border_color',
	$blog_list_masonry_post_info_border_color
);

$blog_list_masonry_post_info_border_width = new HudsonEdgeField(
	'textsimple',
	'blog_list_masonry_post_info_border_width',
	'',
	esc_html__( 'Border Width (px)', 'hudson' ),
	''
);
$row3->addChild(
	'blog_list_masonry_post_info_border_width',
	$blog_list_masonry_post_info_border_width
);

// Image in left box

$image_in_left_box = new HudsonEdgeTitle(
	"image_in_left_box",
	esc_html__( "Blog List - Image in Left Box", 'hudson' )
);
$panel28->addChild(
	"image_in_left_box",
	$image_in_left_box
);

$group28 = new HudsonEdgeGroup(
	esc_html__( "Blog List Title", 'hudson' ),
	esc_html__( "Define Blog List title style", 'hudson' )
);
$panel28->addChild(
	"group28",
	$group28
);
$row1 = new HudsonEdgeRow();
$group28->addChild(
	"row1",
	$row1
);

$blog_list_img_in_lbox_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_img_in_lbox_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_title_color",
	$blog_list_img_in_lbox_title_color
);

$blog_list_img_in_lbox_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_img_in_lbox_title_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_title_hover_color",
	$blog_list_img_in_lbox_title_hover_color
);

$blog_list_img_in_lbox_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_title_font_size",
	$blog_list_img_in_lbox_title_font_size
);

$blog_list_img_in_lbox_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_title_line_height",
	$blog_list_img_in_lbox_title_line_height
);

$row2 = new HudsonEdgeRow( true );
$group28->addChild(
	"row2",
	$row2
);

$blog_list_img_in_lbox_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_list_img_in_lbox_title_text_transform",
	$blog_list_img_in_lbox_title_text_transform
);

$blog_list_img_in_lbox_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_list_img_in_lbox_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_img_in_lbox_title_font_family",
	$blog_list_img_in_lbox_title_font_family
);

$blog_list_img_in_lbox_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_list_img_in_lbox_title_font_style",
	$blog_list_img_in_lbox_title_font_style
);

$blog_list_img_in_lbox_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_list_img_in_lbox_title_font_weight",
	$blog_list_img_in_lbox_title_font_weight
);

$row3 = new HudsonEdgeRow( true );
$group28->addChild(
	"row3",
	$row3
);

$blog_list_img_in_lbox_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_list_img_in_lbox_title_letter_spacing",
	$blog_list_img_in_lbox_title_letter_spacing
);

$group29 = new HudsonEdgeGroup(
	esc_html__( "Blog List Post Info", 'hudson' ),
	esc_html__( "Define blog list post info style", 'hudson' )
);
$panel28->addChild(
	"group29",
	$group29
);
$row1 = new HudsonEdgeRow();
$group29->addChild(
	"row1",
	$row1
);

$blog_list_img_in_lbox_post_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_img_in_lbox_post_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_post_info_color",
	$blog_list_img_in_lbox_post_info_color
);

$blog_list_img_in_lbox_post_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_img_in_lbox_post_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_post_info_link_color",
	$blog_list_img_in_lbox_post_info_link_color
);

$blog_list_img_in_lbox_post_info_link_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_img_in_lbox_post_info_link_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_post_info_link_hover_color",
	$blog_list_img_in_lbox_post_info_link_hover_color
);

$blog_list_img_in_lbox_post_info_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_post_info_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_post_info_font_size",
	$blog_list_img_in_lbox_post_info_font_size
);

$row2 = new HudsonEdgeRow( true );
$group29->addChild(
	"row2",
	$row2
);

$blog_list_img_in_lbox_post_info_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_post_info_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_img_in_lbox_post_info_line_height",
	$blog_list_img_in_lbox_post_info_line_height
);

$blog_list_img_in_lbox_post_info_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_post_info_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_list_img_in_lbox_post_info_text_transform",
	$blog_list_img_in_lbox_post_info_text_transform
);

$blog_list_img_in_lbox_post_info_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_list_img_in_lbox_post_info_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_img_in_lbox_post_info_font_family",
	$blog_list_img_in_lbox_post_info_font_family
);

$blog_list_img_in_lbox_post_info_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_post_info_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_list_img_in_lbox_post_info_font_style",
	$blog_list_img_in_lbox_post_info_font_style
);

$row3 = new HudsonEdgeRow( true );
$group29->addChild(
	"row3",
	$row3
);

$blog_list_img_in_lbox_post_info_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_post_info_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"blog_list_img_in_lbox_post_info_font_weight",
	$blog_list_img_in_lbox_post_info_font_weight
);

$blog_list_img_in_lbox_post_info_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_post_info_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_list_img_in_lbox_post_info_letter_spacing",
	$blog_list_img_in_lbox_post_info_letter_spacing
);

$group30 = new HudsonEdgeGroup(
	esc_html__( "Blog List Date Style", 'hudson' ),
	esc_html__( "Define blog list date style", 'hudson' )
);
$panel28->addChild(
	"group30",
	$group30
);
$row1 = new HudsonEdgeRow();
$group30->addChild(
	"row1",
	$row1
);

$blog_list_img_in_lbox_date_color = new HudsonEdgeField(
	"colorsimple",
	"blog_list_img_in_lbox_date_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_date_color",
	$blog_list_img_in_lbox_date_color
);

$blog_list_img_in_lbox_date_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_date_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_date_font_size",
	$blog_list_img_in_lbox_date_font_size
);

$blog_list_img_in_lbox_date_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_date_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_date_line_height",
	$blog_list_img_in_lbox_date_line_height
);

$blog_list_img_in_lbox_date_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_date_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"blog_list_img_in_lbox_date_text_transform",
	$blog_list_img_in_lbox_date_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group30->addChild(
	"row2",
	$row2
);

$blog_list_img_in_lbox_date_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_list_img_in_lbox_date_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_img_in_lbox_date_font_family",
	$blog_list_img_in_lbox_date_font_family
);

$blog_list_img_in_lbox_date_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_date_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_list_img_in_lbox_date_font_style",
	$blog_list_img_in_lbox_date_font_style
);

$blog_list_img_in_lbox_date_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_list_img_in_lbox_date_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_list_img_in_lbox_date_font_weight",
	$blog_list_img_in_lbox_date_font_weight
);

$blog_list_img_in_lbox_date_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_date_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_list_img_in_lbox_date_letter_spacing",
	$blog_list_img_in_lbox_date_letter_spacing
);

$group31 = new HudsonEdgeGroup(
	esc_html__( "Blog List Spacing", 'hudson' ),
	esc_html__( "Define blog list spacing", 'hudson' )
);
$panel28->addChild(
	"group31",
	$group31
);

$row1 = new HudsonEdgeRow( true );
$group31->addChild(
	"row1",
	$row1
);

$blog_list_img_in_lbox_title_margin_bttm = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_title_margin_bttm",
	"",
	esc_html__( "Margin Under Title (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_title_margin_bttm",
	$blog_list_img_in_lbox_title_margin_bttm
);

$blog_list_img_in_lbox_post_info_margin_bttm = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_post_info_margin_bttm",
	"",
	esc_html__( "Margin Under Post Info (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_post_info_margin_bttm",
	$blog_list_img_in_lbox_post_info_margin_bttm
);

$blog_list_img_in_lbox_read_more_margin_top = new HudsonEdgeField(
	"textsimple",
	"blog_list_img_in_lbox_read_more_margin_top",
	"",
	esc_html__( "Margin Above Read More Button (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_list_img_in_lbox_read_more_margin_top",
	$blog_list_img_in_lbox_read_more_margin_top
);

/*** Blog Carousel ***/

$panel31 = new HudsonEdgePanel(
	esc_html__( "Blog Carousel", 'hudson' ),
	"blog_slider"
);
$blogPage->addChild(
	"panel31",
	$panel31
);

$blog_slider_default_and_with_info_always_title = new HudsonEdgeTitle(
	"blog_slider_default_and_with_info_always_title",
	esc_html__( "Default and Post Info Visible", 'hudson' )
);
$panel31->addChild(
	"blog_slider_default_and_with_info_always_title",
	$blog_slider_default_and_with_info_always_title
);

$group23 = new HudsonEdgeGroup(
	esc_html__( "Title style", 'hudson' ),
	esc_html__( "Blog Carousel title style", 'hudson' )
);
$panel31->addChild(
	"group23",
	$group23
);

$row1 = new HudsonEdgeRow();
$group23->addChild(
	"row1",
	$row1
);

$blog_slider_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_title_color",
	"",
	esc_html__( "Title Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_title_color",
	$blog_slider_title_color
);

$blog_slider_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_title_hover_color",
	"",
	esc_html__( "Title Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_title_hover_color",
	$blog_slider_title_hover_color
);

$blog_slider_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_title_font_size",
	$blog_slider_title_font_size
);

$blog_slider_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_title_line_height",
	$blog_slider_title_line_height
);

$row2 = new HudsonEdgeRow();
$group23->addChild(
	"row2",
	$row2
);

$blog_slider_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_slider_title_text_transform",
	$blog_slider_title_text_transform
);

$blog_slider_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_title_font_family",
	$blog_slider_title_font_family
);

$blog_slider_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_title_font_style",
	$blog_slider_title_font_style
);

$blog_slider_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_slider_title_font_weight",
	$blog_slider_title_font_weight
);

$row3 = new HudsonEdgeRow();
$group23->addChild(
	"row3",
	$row3
);

$blog_slider_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_slider_title_letter_spacing",
	$blog_slider_title_letter_spacing
);

$group24 = new HudsonEdgeGroup(
	esc_html__( "Category style", 'hudson' ),
	esc_html__( "Blog Carousel categories style", 'hudson' )
);
$panel31->addChild(
	"group24",
	$group24
);

$row1 = new HudsonEdgeRow();
$group24->addChild(
	"row1",
	$row1
);

$blog_slider_category_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_category_color",
	"",
	esc_html__( "Category Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_category_color",
	$blog_slider_category_color
);

$blog_slider_category_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_category_hover_color",
	"",
	esc_html__( "Category Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_category_hover_color",
	$blog_slider_category_hover_color
);

$blog_slider_category_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_category_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_category_font_size",
	$blog_slider_category_font_size
);

$blog_slider_category_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_category_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_category_line_height",
	$blog_slider_category_line_height
);

$row2 = new HudsonEdgeRow();
$group24->addChild(
	"row2",
	$row2
);

$blog_slider_category_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_category_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_slider_category_text_transform",
	$blog_slider_category_text_transform
);

$blog_slider_category_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_category_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_category_font_family",
	$blog_slider_category_font_family
);

$blog_slider_category_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_category_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_category_font_style",
	$blog_slider_category_font_style
);

$blog_slider_category_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_category_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_slider_category_font_weight",
	$blog_slider_category_font_weight
);

$row3 = new HudsonEdgeRow();
$group24->addChild(
	"row3",
	$row3
);

$blog_slider_category_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_category_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_slider_category_letter_spacing",
	$blog_slider_category_letter_spacing
);

$group25 = new HudsonEdgeGroup(
	esc_html__( "Date style", 'hudson' ),
	esc_html__( "Blog Carousel date style", 'hudson' )
);
$panel31->addChild(
	"group25",
	$group25
);

$row1 = new HudsonEdgeRow();
$group25->addChild(
	"row1",
	$row1
);

$blog_slider_date_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_date_color",
	"",
	esc_html__( "Date Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_date_color",
	$blog_slider_date_color
);

$blog_slider_date_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_date_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_date_font_size",
	$blog_slider_date_font_size
);

$blog_slider_date_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_date_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_date_line_height",
	$blog_slider_date_line_height
);

$blog_slider_date_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_date_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"blog_slider_date_text_transform",
	$blog_slider_date_text_transform
);

$row2 = new HudsonEdgeRow();
$group25->addChild(
	"row2",
	$row2
);

$blog_slider_date_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_date_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_date_font_family",
	$blog_slider_date_font_family
);

$blog_slider_date_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_date_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_date_font_style",
	$blog_slider_date_font_style
);

$blog_slider_date_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_date_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_slider_date_font_weight",
	$blog_slider_date_font_weight
);

$blog_slider_date_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_date_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_date_letter_spacing",
	$blog_slider_date_letter_spacing
);

$blog_slider_info_in_bottom_title = new HudsonEdgeTitle(
	"blog_slider_info_in_bottom_title",
	esc_html__( "Post Info in Bottom", 'hudson' )
);
$panel31->addChild(
	"blog_slider_info_in_bottom_title",
	$blog_slider_info_in_bottom_title
);

$group26 = new HudsonEdgeGroup(
	esc_html__( "Title style", 'hudson' ),
	esc_html__( "Blog Carousel title style", 'hudson' )
);
$panel31->addChild(
	"group26",
	$group26
);

$row1 = new HudsonEdgeRow();
$group26->addChild(
	"row1",
	$row1
);

$blog_slider_post_info_in_bottom_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_post_info_in_bottom_title_color",
	"",
	esc_html__( "Title Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_title_color",
	$blog_slider_post_info_in_bottom_title_color
);

$blog_slider_post_info_in_bottom_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_post_info_in_bottom_title_hover_color",
	"",
	esc_html__( "Title Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_title_hover_color",
	$blog_slider_post_info_in_bottom_title_hover_color
);

$blog_slider_post_info_in_bottom_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_post_info_in_bottom_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_title_font_size",
	$blog_slider_post_info_in_bottom_title_font_size
);

$blog_slider_post_info_in_bottom_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_post_info_in_bottom_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_title_line_height",
	$blog_slider_post_info_in_bottom_title_line_height
);

$row2 = new HudsonEdgeRow();
$group26->addChild(
	"row2",
	$row2
);

$blog_slider_post_info_in_bottom_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_post_info_in_bottom_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_title_text_transform",
	$blog_slider_post_info_in_bottom_title_text_transform
);

$blog_slider_post_info_in_bottom_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_post_info_in_bottom_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_title_font_family",
	$blog_slider_post_info_in_bottom_title_font_family
);

$blog_slider_post_info_in_bottom_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_post_info_in_bottom_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_title_font_style",
	$blog_slider_post_info_in_bottom_title_font_style
);

$blog_slider_post_info_in_bottom_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_post_info_in_bottom_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_title_font_weight",
	$blog_slider_post_info_in_bottom_title_font_weight
);

$row3 = new HudsonEdgeRow();
$group26->addChild(
	"row3",
	$row3
);

$blog_slider_post_info_in_bottom_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_post_info_in_bottom_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_slider_post_info_in_bottom_title_letter_spacing",
	$blog_slider_post_info_in_bottom_title_letter_spacing
);

$group27 = new HudsonEdgeGroup(
	esc_html__( "Post Info style", 'hudson' ),
	esc_html__( "Blog Carousel post info style", 'hudson' )
);
$panel31->addChild(
	"group27",
	$group27
);

$row1 = new HudsonEdgeRow();
$group27->addChild(
	"row1",
	$row1
);

$blog_slider_post_info_in_bottom_post_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_post_info_in_bottom_post_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_post_info_color",
	$blog_slider_post_info_in_bottom_post_info_color
);

$blog_slider_post_info_in_bottom_post_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_post_info_in_bottom_post_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_post_info_link_color",
	$blog_slider_post_info_in_bottom_post_info_link_color
);

$blog_slider_post_info_in_bottom_post_info_link_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_post_info_in_bottom_post_info_link_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_post_info_link_hover_color",
	$blog_slider_post_info_in_bottom_post_info_link_hover_color
);

$blog_slider_post_info_in_bottom_post_info_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_post_info_in_bottom_post_info_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_post_info_in_bottom_post_info_font_size",
	$blog_slider_post_info_in_bottom_post_info_font_size
);

$row2 = new HudsonEdgeRow();
$group27->addChild(
	"row2",
	$row2
);

$blog_slider_post_info_in_bottom_post_info_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_post_info_in_bottom_post_info_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_post_info_line_height",
	$blog_slider_post_info_in_bottom_post_info_line_height
);

$blog_slider_post_info_in_bottom_post_info_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_post_info_in_bottom_post_info_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_post_info_text_transform",
	$blog_slider_post_info_in_bottom_post_info_text_transform
);

$blog_slider_post_info_in_bottom_post_info_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_post_info_in_bottom_post_info_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_post_info_font_family",
	$blog_slider_post_info_in_bottom_post_info_font_family
);

$blog_slider_post_info_in_bottom_post_info_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_post_info_in_bottom_post_info_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_post_info_in_bottom_post_info_font_style",
	$blog_slider_post_info_in_bottom_post_info_font_style
);

$row3 = new HudsonEdgeRow();
$group27->addChild(
	"row3",
	$row3
);

$blog_slider_post_info_in_bottom_post_info_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_post_info_in_bottom_post_info_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"blog_slider_post_info_in_bottom_post_info_font_weight",
	$blog_slider_post_info_in_bottom_post_info_font_weight
);

$blog_slider_post_info_in_bottom_post_info_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_post_info_in_bottom_post_info_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_slider_post_info_in_bottom_post_info_letter_spacing",
	$blog_slider_post_info_in_bottom_post_info_letter_spacing
);

/*** Blog Slider ***/

$panel32 = new HudsonEdgePanel(
	esc_html__( "Blog Slider", 'hudson' ),
	"blog_slider_simple_simple"
);
$blogPage->addChild(
	"panel32",
	$panel32
);

$blog_slider_simple_simple_box = new HudsonEdgeTitle(
	"blog_slider_simple_simple_box",
	esc_html__( "Box Style", 'hudson' )
);
$panel32->addChild(
	"blog_slider_simple_simple_box",
	$blog_slider_simple_simple_box
);

$blog_slider_simple_box_back_color = new HudsonEdgeField(
	"color",
	"blog_slider_simple_box_back_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel32->addChild(
	"blog_slider_simple_box_back_color",
	$blog_slider_simple_box_back_color
);

$blog_slider_simple_box_opacity = new HudsonEdgeField(
	"text",
	"blog_slider_simple_box_opacity",
	"",
	esc_html__( "Background Opacity", 'hudson' ),
	esc_html__( "Choose a transparency for the shader background color (0 = fully transparent, 1 = opaque)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel32->addChild(
	"blog_slider_simple_box_opacity",
	$blog_slider_simple_box_opacity
);

$blog_slider_simple_box_padding = new HudsonEdgeField(
	"text",
	"blog_slider_simple_box_padding",
	"",
	esc_html__( "Box Padding", 'hudson' ),
	esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px or 5% 5% 5% 5%", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel32->addChild(
	"blog_slider_simple_box_padding",
	$blog_slider_simple_box_padding
);

$blog_slider_simple_box_border_color = new HudsonEdgeField(
	"color",
	"blog_slider_simple_box_border_color",
	"",
	esc_html__( "Box Border Color", 'hudson' ),
	esc_html__( "Choose border color", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel32->addChild(
	"blog_slider_simple_box_border_color",
	$blog_slider_simple_box_border_color
);

$blog_slider_simple_simple_spacing = new HudsonEdgeTitle(
	"blog_slider_simple_simple_spacing",
	esc_html__( "Blog simple slider spacing", 'hudson' )
);
$panel32->addChild(
	"blog_slider_simple_simple_spacing",
	$blog_slider_simple_simple_spacing
);

$blog_slider_simple_info_margin_top = new HudsonEdgeField(
	"text",
	"blog_slider_simple_info_margin_top",
	"",
	esc_html__( "Post Info Margin Top (px)", 'hudson' ),
	esc_html__( "Define post info margin top", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel32->addChild(
	"blog_slider_simple_info_margin_top",
	$blog_slider_simple_info_margin_top
);

$blog_slider_simple_read_more_margin_top = new HudsonEdgeField(
	"text",
	"blog_slider_simple_read_more_margin_top",
	"",
	esc_html__( "Read More Margin Top (px)", 'hudson' ),
	esc_html__( "Define read more margin top", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel32->addChild(
	"blog_slider_simple_read_more_margin_top",
	$blog_slider_simple_read_more_margin_top
);

$blog_slider_simple_simple_text = new HudsonEdgeTitle(
	"blog_slider_simple_simple_text",
	esc_html__( "Post Text Style", 'hudson' )
);
$panel32->addChild(
	"blog_slider_simple_simple_text",
	$blog_slider_simple_simple_text
);

$group_title = new HudsonEdgeGroup(
	esc_html__( "Title style", 'hudson' ),
	esc_html__( "Blog slider title style", 'hudson' )
);
$panel32->addChild(
	"group_title",
	$group_title
);

$row1 = new HudsonEdgeRow();
$group_title->addChild(
	"row1",
	$row1
);

$blog_slider_simple_title_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_simple_title_color",
	"",
	esc_html__( "Title Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_title_color",
	$blog_slider_simple_title_color
);

$blog_slider_simple_title_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_simple_title_hover_color",
	"",
	esc_html__( "Title Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_title_hover_color",
	$blog_slider_simple_title_hover_color
);

$blog_slider_simple_title_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_simple_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_title_font_size",
	$blog_slider_simple_title_font_size
);

$blog_slider_simple_title_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_simple_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_title_line_height",
	$blog_slider_simple_title_line_height
);

$row2 = new HudsonEdgeRow();
$group_title->addChild(
	"row2",
	$row2
);

$blog_slider_simple_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_simple_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_slider_simple_title_text_transform",
	$blog_slider_simple_title_text_transform
);

$blog_slider_simple_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_simple_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_simple_title_font_family",
	$blog_slider_simple_title_font_family
);

$blog_slider_simple_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_simple_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_simple_title_font_style",
	$blog_slider_simple_title_font_style
);

$blog_slider_simple_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_simple_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"blog_slider_simple_title_font_weight",
	$blog_slider_simple_title_font_weight
);

$row3 = new HudsonEdgeRow();
$group_title->addChild(
	"row3",
	$row3
);

$blog_slider_simple_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_simple_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_slider_simple_title_letter_spacing",
	$blog_slider_simple_title_letter_spacing
);

$group_post_info = new HudsonEdgeGroup(
	esc_html__( "Post Info Style", 'hudson' ),
	esc_html__( "Blog slider post info style", 'hudson' )
);
$panel32->addChild(
	"group_post_info",
	$group_post_info
);

$row1 = new HudsonEdgeRow();
$group_post_info->addChild(
	"row1",
	$row1
);

$blog_slider_simple_info_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_simple_info_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_info_color",
	$blog_slider_simple_info_color
);

$blog_slider_simple_info_link_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_simple_info_link_color",
	"",
	esc_html__( "Link Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_info_link_color",
	$blog_slider_simple_info_link_color
);

$blog_slider_simple_info_hover_color = new HudsonEdgeField(
	"colorsimple",
	"blog_slider_simple_info_hover_color",
	"",
	esc_html__( "Link Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_info_hover_color",
	$blog_slider_simple_info_hover_color
);

$blog_slider_simple_info_font_size = new HudsonEdgeField(
	"textsimple",
	"blog_slider_simple_info_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"blog_slider_simple_info_font_size",
	$blog_slider_simple_info_font_size
);

$row2 = new HudsonEdgeRow();
$group_post_info->addChild(
	"row2",
	$row2
);

$blog_slider_simple_info_line_height = new HudsonEdgeField(
	"textsimple",
	"blog_slider_simple_info_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_simple_info_line_height",
	$blog_slider_simple_info_line_height
);

$blog_slider_simple_info_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_simple_info_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"blog_slider_simple_info_text_transform",
	$blog_slider_simple_info_text_transform
);

$blog_slider_simple_info_font_family = new HudsonEdgeField(
	"fontsimple",
	"blog_slider_simple_info_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"blog_slider_simple_info_font_family",
	$blog_slider_simple_info_font_family
);

$blog_slider_simple_info_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_simple_info_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"blog_slider_simple_info_font_style",
	$blog_slider_simple_info_font_style
);

$row3 = new HudsonEdgeRow();
$group_post_info->addChild(
	"row3",
	$row3
);

$blog_slider_simple_info_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"blog_slider_simple_info_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"blog_slider_simple_info_font_weight",
	$blog_slider_simple_info_font_weight
);

$blog_slider_simple_info_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"blog_slider_simple_info_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"blog_slider_simple_info_letter_spacing",
	$blog_slider_simple_info_letter_spacing
);